/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import java.io.Serializable;

public class BarcodeReader
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public BarcodeReader() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = BarcodeReader.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public BarcodeReader(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            BarcodeReader.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public byte[] getOutputData() throws BiosealException {
        byte[] outputData = null;
        int[] outputDataSizeArray = new int[]{-1};
        int err = BarcodeReader.nGetOutputData(this.handle, outputData, outputDataSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            outputData = new byte[outputDataSizeArray[0]];
            err = BarcodeReader.nGetOutputData(this.handle, outputData, outputDataSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return outputData;
    }

    public boolean decode(byte[] data) throws BiosealException {
        boolean[] resultArray = new boolean[1];
        int err = BarcodeReader.nDecode(this.handle, data, resultArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultArray[0];
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetOutputData(long var0, byte[] var2, int[] var3);

    static native int nDecode(long var0, byte[] var2, boolean[] var3);

    static {
        BiosealNative.loadLibraries();
    }
}

