/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

public enum BiometricDataType {
    UNDEFINED(0),
    NO_INFORMATION_GIVEN(1),
    MULTIPLE_BIOMETRICS_USED(2),
    FACIAL_FEATURES(3),
    VOICE(4),
    FINGERPRINT(5),
    IRIS(6),
    RETINA(7),
    HAND_GEOMETRY(8),
    SIGNATURE_DYNAMICS(9),
    KEYSTROKE_DYNAMICS(10),
    LIP_MOVEMENT(11),
    THERMAL_FACE_IMAGE(12),
    THERMAL_HAND_IMAGE(13),
    GAIT(14),
    BODY_ODOR(15),
    DNA(16),
    EAR_SHAPE(17),
    FINGER_GEOMETRY(18),
    PALM_PRINT(19),
    VEIN_PATTERN(20),
    FOOT_PRINT(21);

    private final int value;

    private BiometricDataType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static BiometricDataType fromValue(int value) {
        BiometricDataType[] types;
        for (BiometricDataType type : types = BiometricDataType.values()) {
            if (type.getValue() != value) continue;
            return type;
        }
        throw new IllegalArgumentException("Unable to find the specified enum value for " + value);
    }

    String getMessage() {
        return BiometricDataType.nGetBiosealErrorMessage(this.value);
    }

    static native String nGetBiosealErrorMessage(int var0);
}

