/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiometricDataType;
import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import java.io.Serializable;

public class BiometricVerificationRule
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public BiometricVerificationRule() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = BiometricVerificationRule.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public BiometricVerificationRule(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            BiometricVerificationRule.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public BiometricDataType getDataType() throws BiosealException {
        int[] dataTypeArray = new int[1];
        int err = BiometricVerificationRule.nGetDataType(this.handle, dataTypeArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return BiometricDataType.fromValue(dataTypeArray[0]);
    }

    public int getCount() throws BiosealException {
        int[] countArray = new int[1];
        int err = BiometricVerificationRule.nGetCount(this.handle, countArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return countArray[0];
    }

    public int getThreshold() throws BiosealException {
        int[] thresholdArray = new int[1];
        int err = BiometricVerificationRule.nGetThreshold(this.handle, thresholdArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return thresholdArray[0];
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetDataType(long var0, int[] var2);

    static native int nGetCount(long var0, int[] var2);

    static native int nGetThreshold(long var0, int[] var2);

    static {
        BiosealNative.loadLibraries();
    }
}

