/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiometricVerificationRule;
import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BiometricVerificationRules
implements AutoCloseable,
Serializable,
Iterable<BiometricVerificationRule> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public BiometricVerificationRules() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = BiometricVerificationRules.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public BiometricVerificationRules(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            BiometricVerificationRules.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public boolean getVerifyAll() throws BiosealException {
        boolean[] verifyAllArray = new boolean[1];
        int err = BiometricVerificationRules.nGetVerifyAll(this.handle, verifyAllArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return verifyAllArray[0];
    }

    public BiometricVerificationRule get(int index) throws BiosealException {
        BiometricVerificationRule biometricVerificationRuleItem = new BiometricVerificationRule();
        int err = BiometricVerificationRules.nGet(this.handle, index, biometricVerificationRuleItem.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return biometricVerificationRuleItem;
    }

    public int getCount() throws BiosealException {
        int[] countArray = new int[1];
        int err = BiometricVerificationRules.nGetCount(this.handle, countArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return countArray[0];
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetVerifyAll(long var0, boolean[] var2);

    static native int nGet(long var0, int var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    @Override
    public Iterator<BiometricVerificationRule> iterator() {
        return new Iterator<BiometricVerificationRule>(){
            private int index = 0;
            private final int size = BiometricVerificationRules.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public BiometricVerificationRule next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return BiometricVerificationRules.this.get(this.index++);
            }
        };
    }

    static {
        BiosealNative.loadLibraries();
    }
}

