/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiometricDataType;
import eu.id3.bioseal.BiometricVerificationRules;
import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealFormat;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.CertificateInformation;
import eu.id3.bioseal.DateTime;
import eu.id3.bioseal.DecryptionArgs;
import eu.id3.bioseal.DecryptionCallbackHandler;
import eu.id3.bioseal.Field;
import eu.id3.bioseal.FieldExtensionType;
import eu.id3.bioseal.FieldList;
import eu.id3.bioseal.Log;
import eu.id3.bioseal.Manifest;
import eu.id3.bioseal.ResourceCallbackArgs;
import eu.id3.bioseal.ResourceCallbackHandler;
import eu.id3.bioseal.StringArray;
import eu.id3.bioseal.UserAuthentication;
import eu.id3.bioseal.VerificationResult;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Hashtable;

public class Bioseal
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;
    private static final Hashtable<String, ResourceCallbackHandler> externalResourceCallbackMap;
    private static final Hashtable<String, DecryptionCallbackHandler> decryptionCallbackMap;

    public Bioseal() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = Bioseal.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public Bioseal(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            externalResourceCallbackMap.remove(String.valueOf(this.handle));
            decryptionCallbackMap.remove(String.valueOf(this.handle));
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            Bioseal.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    protected static int _externalResourceCallbackStatic(long context, long args) {
        ResourceCallbackHandler callback = externalResourceCallbackMap.get(String.valueOf(context));
        assert (callback != null);
        return callback.callback(new Bioseal(context), new ResourceCallbackArgs(args));
    }

    protected static int _decryptionCallbackStatic(long context, long args) {
        DecryptionCallbackHandler callback = decryptionCallbackMap.get(String.valueOf(context));
        assert (callback != null);
        return callback.callback(new Bioseal(context), new DecryptionArgs(args));
    }

    public BiosealFormat getFormat() throws BiosealException {
        int[] formatArray = new int[1];
        int err = Bioseal.nGetFormat(this.handle, formatArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return BiosealFormat.fromValue(formatArray[0]);
    }

    public BiosealFormat getExtendedFormat() throws BiosealException {
        int[] extendedFormatArray = new int[1];
        int err = Bioseal.nGetExtendedFormat(this.handle, extendedFormatArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return BiosealFormat.fromValue(extendedFormatArray[0]);
    }

    public DateTime getDocumentIssuingDate() throws BiosealException {
        DateTime documentIssuingDate = new DateTime();
        int err = Bioseal.nGetDocumentIssuingDate(this.handle, documentIssuingDate.getHandle());
        if (err == BiosealError.OBJECT_DOES_NOT_EXIST.getValue()) {
            return null;
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return documentIssuingDate;
    }

    public DateTime getSignatureDate() throws BiosealException {
        DateTime signatureDate = new DateTime();
        int err = Bioseal.nGetSignatureDate(this.handle, signatureDate.getHandle());
        if (err == BiosealError.OBJECT_DOES_NOT_EXIST.getValue()) {
            return null;
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return signatureDate;
    }

    public String getDocumentType() throws BiosealException {
        byte[] documentType = null;
        int[] documentTypeSizeArray = new int[]{-1};
        int err = Bioseal.nGetDocumentType(this.handle, documentType, documentTypeSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            documentType = new byte[documentTypeSizeArray[0]];
            err = Bioseal.nGetDocumentType(this.handle, documentType, documentTypeSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(documentType, 0, documentTypeSizeArray[0], Charset.defaultCharset());
    }

    public String getDocumentScope() throws BiosealException {
        byte[] documentScope = null;
        int[] documentScopeSizeArray = new int[]{-1};
        int err = Bioseal.nGetDocumentScope(this.handle, documentScope, documentScopeSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            documentScope = new byte[documentScopeSizeArray[0]];
            err = Bioseal.nGetDocumentScope(this.handle, documentScope, documentScopeSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(documentScope, 0, documentScopeSizeArray[0], Charset.defaultCharset());
    }

    public String getDocumentIssuingCountry() throws BiosealException {
        byte[] documentIssuingCountry = null;
        int[] documentIssuingCountrySizeArray = new int[]{-1};
        int err = Bioseal.nGetDocumentIssuingCountry(this.handle, documentIssuingCountry, documentIssuingCountrySizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            documentIssuingCountry = new byte[documentIssuingCountrySizeArray[0]];
            err = Bioseal.nGetDocumentIssuingCountry(this.handle, documentIssuingCountry, documentIssuingCountrySizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(documentIssuingCountry, 0, documentIssuingCountrySizeArray[0], Charset.defaultCharset());
    }

    public int getManifestId() throws BiosealException {
        int[] manifestIdArray = new int[1];
        int err = Bioseal.nGetManifestId(this.handle, manifestIdArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return manifestIdArray[0];
    }

    public Field getPayload() throws BiosealException {
        Field payload = new Field();
        int err = Bioseal.nGetPayload(this.handle, payload.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return payload;
    }

    public Manifest getManifest() throws BiosealException {
        Manifest manifest = new Manifest();
        int err = Bioseal.nGetManifest(this.handle, manifest.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return manifest;
    }

    public boolean getContainsImages() throws BiosealException {
        boolean[] containsImagesArray = new boolean[1];
        int err = Bioseal.nGetContainsImages(this.handle, containsImagesArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return containsImagesArray[0];
    }

    public boolean getContainsPortraits() throws BiosealException {
        boolean[] containsPortraitsArray = new boolean[1];
        int err = Bioseal.nGetContainsPortraits(this.handle, containsPortraitsArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return containsPortraitsArray[0];
    }

    public boolean getContainsBiometrics() throws BiosealException {
        boolean[] containsBiometricsArray = new boolean[1];
        int err = Bioseal.nGetContainsBiometrics(this.handle, containsBiometricsArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return containsBiometricsArray[0];
    }

    public boolean getContainsFaceTemplates() throws BiosealException {
        boolean[] containsFaceTemplatesArray = new boolean[1];
        int err = Bioseal.nGetContainsFaceTemplates(this.handle, containsFaceTemplatesArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return containsFaceTemplatesArray[0];
    }

    public boolean getContainsFingerTemplates() throws BiosealException {
        boolean[] containsFingerTemplatesArray = new boolean[1];
        int err = Bioseal.nGetContainsFingerTemplates(this.handle, containsFingerTemplatesArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return containsFingerTemplatesArray[0];
    }

    public boolean getContainsExtensions() throws BiosealException {
        boolean[] containsExtensionsArray = new boolean[1];
        int err = Bioseal.nGetContainsExtensions(this.handle, containsExtensionsArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return containsExtensionsArray[0];
    }

    public StringArray getSupportedLanguages() throws BiosealException {
        StringArray supportedLanguages = new StringArray();
        int err = Bioseal.nGetSupportedLanguages(this.handle, supportedLanguages.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return supportedLanguages;
    }

    public String getHtmlView() throws BiosealException {
        byte[] htmlView = null;
        int[] htmlViewSizeArray = new int[]{-1};
        int err = Bioseal.nGetHtmlView(this.handle, htmlView, htmlViewSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            htmlView = new byte[htmlViewSizeArray[0]];
            err = Bioseal.nGetHtmlView(this.handle, htmlView, htmlViewSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(htmlView, 0, htmlViewSizeArray[0], Charset.defaultCharset());
    }

    public void setExternalResourceCallback(ResourceCallbackHandler externalResourceCallback) throws BiosealException {
        externalResourceCallbackMap.put(String.valueOf(this.handle), externalResourceCallback);
        int err = Bioseal.nSetExternalResourceCallback(this.handle);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public String getCertificateAuthorityReference() throws BiosealException {
        byte[] certificateAuthorityReference = null;
        int[] certificateAuthorityReferenceSizeArray = new int[]{-1};
        int err = Bioseal.nGetCertificateAuthorityReference(this.handle, certificateAuthorityReference, certificateAuthorityReferenceSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            certificateAuthorityReference = new byte[certificateAuthorityReferenceSizeArray[0]];
            err = Bioseal.nGetCertificateAuthorityReference(this.handle, certificateAuthorityReference, certificateAuthorityReferenceSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(certificateAuthorityReference, 0, certificateAuthorityReferenceSizeArray[0], Charset.defaultCharset());
    }

    public String getCertificateIdentifier() throws BiosealException {
        byte[] certificateIdentifier = null;
        int[] certificateIdentifierSizeArray = new int[]{-1};
        int err = Bioseal.nGetCertificateIdentifier(this.handle, certificateIdentifier, certificateIdentifierSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            certificateIdentifier = new byte[certificateIdentifierSizeArray[0]];
            err = Bioseal.nGetCertificateIdentifier(this.handle, certificateIdentifier, certificateIdentifierSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(certificateIdentifier, 0, certificateIdentifierSizeArray[0], Charset.defaultCharset());
    }

    public CertificateInformation getCertificateInformation() throws BiosealException {
        CertificateInformation certificateInformation = new CertificateInformation();
        int err = Bioseal.nGetCertificateInformation(this.handle, certificateInformation.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return certificateInformation;
    }

    public DateTime getExpirationDate() throws BiosealException {
        DateTime expirationDate = new DateTime();
        int err = Bioseal.nGetExpirationDate(this.handle, expirationDate.getHandle());
        if (err == BiosealError.OBJECT_DOES_NOT_EXIST.getValue()) {
            return null;
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return expirationDate;
    }

    public boolean getContainsAuxData() throws BiosealException {
        boolean[] containsAuxDataArray = new boolean[1];
        int err = Bioseal.nGetContainsAuxData(this.handle, containsAuxDataArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return containsAuxDataArray[0];
    }

    public Field getAuxData() throws BiosealException {
        Field auxData = new Field();
        int err = Bioseal.nGetAuxData(this.handle, auxData.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return auxData;
    }

    public BiometricVerificationRules getBiometricVerificationRules() throws BiosealException {
        BiometricVerificationRules biometricVerificationRules = new BiometricVerificationRules();
        int err = Bioseal.nGetBiometricVerificationRules(this.handle, biometricVerificationRules.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return biometricVerificationRules;
    }

    public Log getLog() throws BiosealException {
        Log log = new Log();
        int err = Bioseal.nGetLog(this.handle, log.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return log;
    }

    public UserAuthentication getUserAuthentication() throws BiosealException {
        UserAuthentication userAuthentication = new UserAuthentication();
        int err = Bioseal.nGetUserAuthentication(this.handle, userAuthentication.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return userAuthentication;
    }

    public int getHeaderVersion() throws BiosealException {
        int[] headerVersionArray = new int[1];
        int err = Bioseal.nGetHeaderVersion(this.handle, headerVersionArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return headerVersionArray[0];
    }

    public void setDecryptionCallback(DecryptionCallbackHandler decryptionCallback) throws BiosealException {
        decryptionCallbackMap.put(String.valueOf(this.handle), decryptionCallback);
        int err = Bioseal.nSetDecryptionCallback(this.handle);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public boolean getVerifiesGovernance() throws BiosealException {
        boolean[] verifiesGovernanceArray = new boolean[1];
        int err = Bioseal.nGetVerifiesGovernance(this.handle, verifiesGovernanceArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return verifiesGovernanceArray[0];
    }

    public void setVerifiesGovernance(boolean verifiesGovernance) throws BiosealException {
        int err = Bioseal.nSetVerifiesGovernance(this.handle, verifiesGovernance);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public boolean getVerifiesSignature() throws BiosealException {
        boolean[] verifiesSignatureArray = new boolean[1];
        int err = Bioseal.nGetVerifiesSignature(this.handle, verifiesSignatureArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return verifiesSignatureArray[0];
    }

    public void setVerifiesSignature(boolean verifiesSignature) throws BiosealException {
        int err = Bioseal.nSetVerifiesSignature(this.handle, verifiesSignature);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public boolean getVerifiesCrlUpdates() throws BiosealException {
        boolean[] verifiesCrlUpdatesArray = new boolean[1];
        int err = Bioseal.nGetVerifiesCrlUpdates(this.handle, verifiesCrlUpdatesArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return verifiesCrlUpdatesArray[0];
    }

    public void setVerifiesCrlUpdates(boolean verifiesCrlUpdates) throws BiosealException {
        int err = Bioseal.nSetVerifiesCrlUpdates(this.handle, verifiesCrlUpdates);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public VerificationResult getVerificationResult() throws BiosealException {
        VerificationResult verificationResult = new VerificationResult();
        int err = Bioseal.nGetVerificationResult(this.handle, verificationResult);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return verificationResult;
    }

    public String getLotlUrl() throws BiosealException {
        byte[] lotlUrl = null;
        int[] lotlUrlSizeArray = new int[]{-1};
        int err = Bioseal.nGetLotlUrl(this.handle, lotlUrl, lotlUrlSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            lotlUrl = new byte[lotlUrlSizeArray[0]];
            err = Bioseal.nGetLotlUrl(this.handle, lotlUrl, lotlUrlSizeArray);
        }
        if (err == BiosealError.OBJECT_DOES_NOT_EXIST.getValue()) {
            return null;
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(lotlUrl, 0, lotlUrlSizeArray[0], Charset.defaultCharset());
    }

    public void setLotlUrl(String lotlUrl) throws BiosealException {
        int err = Bioseal.nSetLotlUrl(this.handle, lotlUrl);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public String getTslUrl() throws BiosealException {
        byte[] tslUrl = null;
        int[] tslUrlSizeArray = new int[]{-1};
        int err = Bioseal.nGetTslUrl(this.handle, tslUrl, tslUrlSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            tslUrl = new byte[tslUrlSizeArray[0]];
            err = Bioseal.nGetTslUrl(this.handle, tslUrl, tslUrlSizeArray);
        }
        if (err == BiosealError.OBJECT_DOES_NOT_EXIST.getValue()) {
            return null;
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(tslUrl, 0, tslUrlSizeArray[0], Charset.defaultCharset());
    }

    public void setTslUrl(String tslUrl) throws BiosealException {
        int err = Bioseal.nSetTslUrl(this.handle, tslUrl);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public String getManifestUrl() throws BiosealException {
        byte[] manifestUrl = null;
        int[] manifestUrlSizeArray = new int[]{-1};
        int err = Bioseal.nGetManifestUrl(this.handle, manifestUrl, manifestUrlSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            manifestUrl = new byte[manifestUrlSizeArray[0]];
            err = Bioseal.nGetManifestUrl(this.handle, manifestUrl, manifestUrlSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(manifestUrl, 0, manifestUrlSizeArray[0], Charset.defaultCharset());
    }

    public void setManifestUrl(String manifestUrl) throws BiosealException {
        int err = Bioseal.nSetManifestUrl(this.handle, manifestUrl);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public String getIssuingAgencyCode() throws BiosealException {
        byte[] issuingAgencyCode = null;
        int[] issuingAgencyCodeSizeArray = new int[]{-1};
        int err = Bioseal.nGetIssuingAgencyCode(this.handle, issuingAgencyCode, issuingAgencyCodeSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            issuingAgencyCode = new byte[issuingAgencyCodeSizeArray[0]];
            err = Bioseal.nGetIssuingAgencyCode(this.handle, issuingAgencyCode, issuingAgencyCodeSizeArray);
        }
        if (err == BiosealError.OBJECT_DOES_NOT_EXIST.getValue()) {
            return null;
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(issuingAgencyCode, 0, issuingAgencyCodeSizeArray[0], Charset.defaultCharset());
    }

    public boolean getHasPrefix() throws BiosealException {
        boolean[] hasPrefixArray = new boolean[1];
        int err = Bioseal.nGetHasPrefix(this.handle, hasPrefixArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return hasPrefixArray[0];
    }

    public String getPrefix() throws BiosealException {
        byte[] prefix = null;
        int[] prefixSizeArray = new int[]{-1};
        int err = Bioseal.nGetPrefix(this.handle, prefix, prefixSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            prefix = new byte[prefixSizeArray[0]];
            err = Bioseal.nGetPrefix(this.handle, prefix, prefixSizeArray);
        }
        if (err == BiosealError.OBJECT_DOES_NOT_EXIST.getValue()) {
            return null;
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(prefix, 0, prefixSizeArray[0], Charset.defaultCharset());
    }

    public byte[] getData() throws BiosealException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = Bioseal.nGetData(this.handle, data, dataSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = Bioseal.nGetData(this.handle, data, dataSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return data;
    }

    public void clear() throws BiosealException {
        int err = Bioseal.nClear(this.handle);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public VerificationResult verifyFromBuffer(byte[] data) throws BiosealException {
        VerificationResult result = new VerificationResult();
        int err = Bioseal.nVerifyFromBuffer(this.handle, data, result);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return result;
    }

    public VerificationResult verifyFromString(String data) throws BiosealException {
        VerificationResult result = new VerificationResult();
        int err = Bioseal.nVerifyFromString(this.handle, data, result);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return result;
    }

    public void buildHtmlView(String language, boolean userAuthenticated) throws BiosealException {
        int err = Bioseal.nBuildHtmlView(this.handle, language, userAuthenticated);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public String getDocumentName(String language) throws BiosealException {
        byte[] documentName = null;
        int[] documentNameSizeArray = new int[]{-1};
        int err = Bioseal.nGetDocumentName(this.handle, language, documentName, documentNameSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            documentName = new byte[documentNameSizeArray[0]];
            err = Bioseal.nGetDocumentName(this.handle, language, documentName, documentNameSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(documentName, 0, documentNameSizeArray[0], Charset.defaultCharset());
    }

    public String getDocumentDescription(String language) throws BiosealException {
        byte[] documentDescription = null;
        int[] documentDescriptionSizeArray = new int[]{-1};
        int err = Bioseal.nGetDocumentDescription(this.handle, language, documentDescription, documentDescriptionSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            documentDescription = new byte[documentDescriptionSizeArray[0]];
            err = Bioseal.nGetDocumentDescription(this.handle, language, documentDescription, documentDescriptionSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(documentDescription, 0, documentDescriptionSizeArray[0], Charset.defaultCharset());
    }

    public FieldList findFieldsByExtension(FieldExtensionType fieldExtensionType) throws BiosealException {
        FieldList resultFieldList = new FieldList();
        int err = Bioseal.nFindFieldsByExtension(this.handle, fieldExtensionType.getValue(), resultFieldList.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultFieldList;
    }

    public FieldList findFieldsByExtensionName(String extensionName) throws BiosealException {
        FieldList resultFieldList = new FieldList();
        int err = Bioseal.nFindFieldsByExtensionName(this.handle, extensionName, resultFieldList.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultFieldList;
    }

    public FieldList findBiometrics(BiometricDataType biometricDataType, String biometricFormat) throws BiosealException {
        FieldList resultFieldList = new FieldList();
        int err = Bioseal.nFindBiometrics(this.handle, biometricDataType.getValue(), biometricFormat, resultFieldList.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultFieldList;
    }

    public String buildVdsAsJson(String indentation) throws BiosealException {
        byte[] result = null;
        int[] resultSizeArray = new int[]{-1};
        int err = Bioseal.nBuildVdsAsJson(this.handle, indentation, result, resultSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            result = new byte[resultSizeArray[0]];
            err = Bioseal.nBuildVdsAsJson(this.handle, indentation, result, resultSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(result, 0, resultSizeArray[0], Charset.defaultCharset());
    }

    public String buildVdsAsXml(String language) throws BiosealException {
        byte[] result = null;
        int[] resultSizeArray = new int[]{-1};
        int err = Bioseal.nBuildVdsAsXml(this.handle, language, result, resultSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            result = new byte[resultSizeArray[0]];
            err = Bioseal.nBuildVdsAsXml(this.handle, language, result, resultSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(result, 0, resultSizeArray[0], Charset.defaultCharset());
    }

    public void clearDownloadCache() throws BiosealException {
        int err = Bioseal.nClearDownloadCache(this.handle);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public void setTimeZoneOffset(int offsetInSeconds) throws BiosealException {
        int err = Bioseal.nSetTimeZoneOffset(this.handle, offsetInSeconds);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public static String computeSha256(byte[] data) throws BiosealException {
        byte[] result = null;
        int[] resultSizeArray = new int[]{-1};
        int err = Bioseal.nComputeSha256(data, result, resultSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            result = new byte[resultSizeArray[0]];
            err = Bioseal.nComputeSha256(data, result, resultSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(result, 0, resultSizeArray[0], Charset.defaultCharset());
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetFormat(long var0, int[] var2);

    static native int nGetExtendedFormat(long var0, int[] var2);

    static native int nGetDocumentIssuingDate(long var0, long var2);

    static native int nGetSignatureDate(long var0, long var2);

    static native int nGetDocumentType(long var0, byte[] var2, int[] var3);

    static native int nGetDocumentScope(long var0, byte[] var2, int[] var3);

    static native int nGetDocumentIssuingCountry(long var0, byte[] var2, int[] var3);

    static native int nGetManifestId(long var0, int[] var2);

    static native int nGetPayload(long var0, long var2);

    static native int nGetManifest(long var0, long var2);

    static native int nGetContainsImages(long var0, boolean[] var2);

    static native int nGetContainsPortraits(long var0, boolean[] var2);

    static native int nGetContainsBiometrics(long var0, boolean[] var2);

    static native int nGetContainsFaceTemplates(long var0, boolean[] var2);

    static native int nGetContainsFingerTemplates(long var0, boolean[] var2);

    static native int nGetContainsExtensions(long var0, boolean[] var2);

    static native int nGetSupportedLanguages(long var0, long var2);

    static native int nGetHtmlView(long var0, byte[] var2, int[] var3);

    static native int nSetExternalResourceCallback(long var0);

    static native int nGetCertificateAuthorityReference(long var0, byte[] var2, int[] var3);

    static native int nGetCertificateIdentifier(long var0, byte[] var2, int[] var3);

    static native int nGetCertificateInformation(long var0, long var2);

    static native int nGetExpirationDate(long var0, long var2);

    static native int nGetContainsAuxData(long var0, boolean[] var2);

    static native int nGetAuxData(long var0, long var2);

    static native int nGetBiometricVerificationRules(long var0, long var2);

    static native int nGetLog(long var0, long var2);

    static native int nGetUserAuthentication(long var0, long var2);

    static native int nGetHeaderVersion(long var0, int[] var2);

    static native int nSetDecryptionCallback(long var0);

    static native int nGetVerifiesGovernance(long var0, boolean[] var2);

    static native int nSetVerifiesGovernance(long var0, boolean var2);

    static native int nGetVerifiesSignature(long var0, boolean[] var2);

    static native int nSetVerifiesSignature(long var0, boolean var2);

    static native int nGetVerifiesCrlUpdates(long var0, boolean[] var2);

    static native int nSetVerifiesCrlUpdates(long var0, boolean var2);

    static native int nGetVerificationResult(long var0, VerificationResult var2);

    static native int nGetLotlUrl(long var0, byte[] var2, int[] var3);

    static native int nSetLotlUrl(long var0, String var2);

    static native int nGetTslUrl(long var0, byte[] var2, int[] var3);

    static native int nSetTslUrl(long var0, String var2);

    static native int nGetManifestUrl(long var0, byte[] var2, int[] var3);

    static native int nSetManifestUrl(long var0, String var2);

    static native int nGetIssuingAgencyCode(long var0, byte[] var2, int[] var3);

    static native int nGetHasPrefix(long var0, boolean[] var2);

    static native int nGetPrefix(long var0, byte[] var2, int[] var3);

    static native int nGetData(long var0, byte[] var2, int[] var3);

    static native int nClear(long var0);

    static native int nVerifyFromBuffer(long var0, byte[] var2, VerificationResult var3);

    static native int nVerifyFromString(long var0, String var2, VerificationResult var3);

    static native int nBuildHtmlView(long var0, String var2, boolean var3);

    static native int nGetDocumentName(long var0, String var2, byte[] var3, int[] var4);

    static native int nGetDocumentDescription(long var0, String var2, byte[] var3, int[] var4);

    static native int nFindFieldsByExtension(long var0, int var2, long var3);

    static native int nFindFieldsByExtensionName(long var0, String var2, long var3);

    static native int nFindBiometrics(long var0, int var2, String var3, long var4);

    static native int nBuildVdsAsJson(long var0, String var2, byte[] var3, int[] var4);

    static native int nBuildVdsAsXml(long var0, String var2, byte[] var3, int[] var4);

    static native int nClearDownloadCache(long var0);

    static native int nSetTimeZoneOffset(long var0, int var2);

    static native int nComputeSha256(byte[] var0, byte[] var1, int[] var2);

    static {
        BiosealNative.loadLibraries();
        externalResourceCallbackMap = new Hashtable();
        decryptionCallbackMap = new Hashtable();
    }
}

