/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.LibVersion;
import java.nio.charset.Charset;

public class BiosealLibrary {
    public static String getVersion() throws BiosealException {
        byte[] libraryVersion = new byte[8];
        int[] libraryVersionSizeArray = new int[]{8};
        int err = BiosealLibrary.nGetVersion(libraryVersion, libraryVersionSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            libraryVersion = new byte[libraryVersionSizeArray[0]];
            err = BiosealLibrary.nGetVersion(libraryVersion, libraryVersionSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(libraryVersion, 0, libraryVersionSizeArray[0], Charset.defaultCharset());
    }

    public static LibVersion getVersionEx() throws BiosealException {
        LibVersion version = new LibVersion();
        int err = BiosealLibrary.nGetVersionEx(version);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return version;
    }

    static native int nGetVersion(byte[] var0, int[] var1);

    static native int nGetVersionEx(LibVersion var0);

    static {
        BiosealNative.loadLibraries();
    }
}

