/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.LicenseHardwareCodeType;
import eu.id3.bioseal.LicenseType;
import java.nio.charset.Charset;
import java.util.Arrays;

public class BiosealLicense {
    public static void checkLicense(String licensePath) throws BiosealException {
        int err = BiosealLicense.nCheckLicense(licensePath);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public static void checkLicenseBuffer(byte[] licenseData) throws BiosealException {
        int err = BiosealLicense.nCheckLicenseBuffer(licenseData);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public static void checkModule(String moduleName) throws BiosealException {
        int err = BiosealLicense.nCheckModule(moduleName);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public static int getModuleCount() throws BiosealException {
        int[] countArray = new int[1];
        int err = BiosealLicense.nGetModuleCount(countArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return countArray[0];
    }

    public static String getModuleName(int index) throws BiosealException {
        byte[] name = new byte[256];
        int[] nameSizeArray = new int[]{256};
        int err = BiosealLicense.nGetModuleName(index, name, nameSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            name = new byte[nameSizeArray[0]];
            err = BiosealLicense.nGetModuleName(index, name, nameSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(name, 0, nameSizeArray[0], Charset.defaultCharset());
    }

    public static int getModuleValue(String name) throws BiosealException {
        int[] valueArray = new int[1];
        int err = BiosealLicense.nGetModuleValue(name, valueArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueArray[0];
    }

    public static String getLicenseName() throws BiosealException {
        byte[] licenseName = new byte[256];
        int[] licenseNameSizeArray = new int[]{256};
        int err = BiosealLicense.nGetLicenseName(licenseName, licenseNameSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            licenseName = new byte[licenseNameSizeArray[0]];
            err = BiosealLicense.nGetLicenseName(licenseName, licenseNameSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(licenseName, 0, licenseNameSizeArray[0], Charset.defaultCharset());
    }

    public static LicenseType getLicenseType() throws BiosealException {
        int[] biosealLicenseTypeArray = new int[1];
        int err = BiosealLicense.nGetLicenseType(biosealLicenseTypeArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return LicenseType.fromValue(biosealLicenseTypeArray[0]);
    }

    public static String getLicenseOwner() throws BiosealException {
        byte[] licenseOwner = new byte[256];
        int[] licenseOwnerSizeArray = new int[]{256};
        int err = BiosealLicense.nGetLicenseOwner(licenseOwner, licenseOwnerSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            licenseOwner = new byte[licenseOwnerSizeArray[0]];
            err = BiosealLicense.nGetLicenseOwner(licenseOwner, licenseOwnerSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(licenseOwner, 0, licenseOwnerSizeArray[0], Charset.defaultCharset());
    }

    public static String getProductReference() throws BiosealException {
        byte[] productReference = new byte[256];
        int[] productReferenceSizeArray = new int[]{256};
        int err = BiosealLicense.nGetProductReference(productReference, productReferenceSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            productReference = new byte[productReferenceSizeArray[0]];
            err = BiosealLicense.nGetProductReference(productReference, productReferenceSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(productReference, 0, productReferenceSizeArray[0], Charset.defaultCharset());
    }

    public static String getLicensePath() throws BiosealException {
        byte[] licensePath = new byte[256];
        int[] licensePathSizeArray = new int[]{256};
        int err = BiosealLicense.nGetLicensePath(licensePath, licensePathSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            licensePath = new byte[licensePathSizeArray[0]];
            err = BiosealLicense.nGetLicensePath(licensePath, licensePathSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(licensePath, 0, licensePathSizeArray[0], Charset.defaultCharset());
    }

    public static int getRemainingDays() throws BiosealException {
        int[] remainingDaysArray = new int[1];
        int err = BiosealLicense.nGetRemainingDays(remainingDaysArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return remainingDaysArray[0];
    }

    public static String getExpiryDate() throws BiosealException {
        byte[] expiryDate = new byte[256];
        int[] expiryDateSizeArray = new int[]{256};
        int err = BiosealLicense.nGetExpiryDate(expiryDate, expiryDateSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            expiryDate = new byte[expiryDateSizeArray[0]];
            err = BiosealLicense.nGetExpiryDate(expiryDate, expiryDateSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(expiryDate, 0, expiryDateSizeArray[0], Charset.defaultCharset());
    }

    public static String getLicenseFileHardwareCode() throws BiosealException {
        byte[] licenseFileHardwareCode = new byte[256];
        int[] licenseFileHardwareCodeSizeArray = new int[]{256};
        int err = BiosealLicense.nGetLicenseFileHardwareCode(licenseFileHardwareCode, licenseFileHardwareCodeSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileHardwareCode = new byte[licenseFileHardwareCodeSizeArray[0]];
            err = BiosealLicense.nGetLicenseFileHardwareCode(licenseFileHardwareCode, licenseFileHardwareCodeSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(licenseFileHardwareCode, 0, licenseFileHardwareCodeSizeArray[0], Charset.defaultCharset());
    }

    public static String getLicenseFileSerial() throws BiosealException {
        byte[] licenseFileSerial = new byte[256];
        int[] licenseFileSerialSizeArray = new int[]{256};
        int err = BiosealLicense.nGetLicenseFileSerial(licenseFileSerial, licenseFileSerialSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileSerial = new byte[licenseFileSerialSizeArray[0]];
            err = BiosealLicense.nGetLicenseFileSerial(licenseFileSerial, licenseFileSerialSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(licenseFileSerial, 0, licenseFileSerialSizeArray[0], Charset.defaultCharset());
    }

    public static String getHostHardwareCode(LicenseHardwareCodeType hardwareCodeType) throws BiosealException {
        byte[] code = new byte[256];
        int[] codeSizeArray = new int[]{256};
        int err = BiosealLicense.nGetHostHardwareCode(hardwareCodeType.getValue(), code, codeSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            code = new byte[codeSizeArray[0]];
            err = BiosealLicense.nGetHostHardwareCode(hardwareCodeType.getValue(), code, codeSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(code, 0, codeSizeArray[0], Charset.defaultCharset());
    }

    public static String getExternalDriveHardwareCode(LicenseHardwareCodeType hardwareCodeType, String externalDrivePath) throws BiosealException {
        byte[] code = new byte[256];
        int[] codeSizeArray = new int[]{256};
        int err = BiosealLicense.nGetExternalDriveHardwareCode(hardwareCodeType.getValue(), code, codeSizeArray, externalDrivePath);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            code = new byte[codeSizeArray[0]];
            err = BiosealLicense.nGetExternalDriveHardwareCode(hardwareCodeType.getValue(), code, codeSizeArray, externalDrivePath);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(code, 0, codeSizeArray[0], Charset.defaultCharset());
    }

    public static String getLicenseComment() throws BiosealException {
        byte[] licenseComment = new byte[256];
        int[] licenseCommentSizeArray = new int[]{256};
        int err = BiosealLicense.nGetLicenseComment(licenseComment, licenseCommentSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            licenseComment = new byte[licenseCommentSizeArray[0]];
            err = BiosealLicense.nGetLicenseComment(licenseComment, licenseCommentSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(licenseComment, 0, licenseCommentSizeArray[0], Charset.defaultCharset());
    }

    public static void activate(String hardwareCode, String login, String password, String productReference, String commentary, String path) throws BiosealException {
        int err = BiosealLicense.nActivate(hardwareCode, login, password, productReference, commentary, path);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public static byte[] activateBuffer(String hardwareCode, String login, String password, String productReference, String commentary) throws BiosealException {
        byte[] licenseFileBuffer = new byte[2048];
        int[] licenseFileBufferSizeArray = new int[]{2048};
        int err = BiosealLicense.nActivateBuffer(hardwareCode, login, password, productReference, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        if (err == BiosealError.SUCCESS.getValue()) {
            return Arrays.copyOf(licenseFileBuffer, licenseFileBufferSizeArray[0]);
        }
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileBuffer = new byte[licenseFileBufferSizeArray[0]];
            err = BiosealLicense.nActivateBuffer(hardwareCode, login, password, productReference, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return licenseFileBuffer;
    }

    public static void activateSerialKey(String hardwareCode, String serialKey, String commentary, String path) throws BiosealException {
        int err = BiosealLicense.nActivateSerialKey(hardwareCode, serialKey, commentary, path);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public static byte[] activateSerialKeyBuffer(String hardwareCode, String serialKey, String commentary) throws BiosealException {
        byte[] licenseFileBuffer = new byte[2048];
        int[] licenseFileBufferSizeArray = new int[]{2048};
        int err = BiosealLicense.nActivateSerialKeyBuffer(hardwareCode, serialKey, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        if (err == BiosealError.SUCCESS.getValue()) {
            return Arrays.copyOf(licenseFileBuffer, licenseFileBufferSizeArray[0]);
        }
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileBuffer = new byte[licenseFileBufferSizeArray[0]];
            err = BiosealLicense.nActivateSerialKeyBuffer(hardwareCode, serialKey, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return licenseFileBuffer;
    }

    public static void activateActivationKey(String hardwareCode, String activationKey, String commentary, String path) throws BiosealException {
        int err = BiosealLicense.nActivateActivationKey(hardwareCode, activationKey, commentary, path);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public static byte[] activateActivationKeyBuffer(String hardwareCode, String activationKey, String commentary) throws BiosealException {
        byte[] licenseFileBuffer = new byte[2048];
        int[] licenseFileBufferSizeArray = new int[]{2048};
        int err = BiosealLicense.nActivateActivationKeyBuffer(hardwareCode, activationKey, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        if (err == BiosealError.SUCCESS.getValue()) {
            return Arrays.copyOf(licenseFileBuffer, licenseFileBufferSizeArray[0]);
        }
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileBuffer = new byte[licenseFileBufferSizeArray[0]];
            err = BiosealLicense.nActivateActivationKeyBuffer(hardwareCode, activationKey, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return licenseFileBuffer;
    }

    public static void reactivate(String hardwareCode, String productReference, String path) throws BiosealException {
        int err = BiosealLicense.nReactivate(hardwareCode, productReference, path);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public static byte[] reactivateBuffer(String hardwareCode, String productReference) throws BiosealException {
        byte[] licenseFileBuffer = new byte[2048];
        int[] licenseFileBufferSizeArray = new int[]{2048};
        int err = BiosealLicense.nReactivateBuffer(hardwareCode, productReference, licenseFileBuffer, licenseFileBufferSizeArray);
        if (err == BiosealError.SUCCESS.getValue()) {
            return Arrays.copyOf(licenseFileBuffer, licenseFileBufferSizeArray[0]);
        }
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileBuffer = new byte[licenseFileBufferSizeArray[0]];
            err = BiosealLicense.nReactivateBuffer(hardwareCode, productReference, licenseFileBuffer, licenseFileBufferSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return licenseFileBuffer;
    }

    public static byte[] checkLicenseWithCard(String licensePath) throws BiosealException {
        byte[] challengeR1 = new byte[16];
        int[] challengeR1SizeArray = new int[]{16};
        int err = BiosealLicense.nCheckLicenseWithCard(licensePath, challengeR1, challengeR1SizeArray);
        if (err == BiosealError.SUCCESS.getValue()) {
            return Arrays.copyOf(challengeR1, challengeR1SizeArray[0]);
        }
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            challengeR1 = new byte[challengeR1SizeArray[0]];
            err = BiosealLicense.nCheckLicenseWithCard(licensePath, challengeR1, challengeR1SizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return challengeR1;
    }

    public static byte[] checkLicenseBufferWithCard(byte[] licenseData) throws BiosealException {
        byte[] challengeR1 = new byte[16];
        int[] challengeR1SizeArray = new int[]{16};
        int err = BiosealLicense.nCheckLicenseBufferWithCard(licenseData, challengeR1, challengeR1SizeArray);
        if (err == BiosealError.SUCCESS.getValue()) {
            return Arrays.copyOf(challengeR1, challengeR1SizeArray[0]);
        }
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            challengeR1 = new byte[challengeR1SizeArray[0]];
            err = BiosealLicense.nCheckLicenseBufferWithCard(licenseData, challengeR1, challengeR1SizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return challengeR1;
    }

    public static void finalizeCheckLicenseWithCard(byte[] cryptogram) throws BiosealException {
        int err = BiosealLicense.nFinalizeCheckLicenseWithCard(cryptogram);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public static byte[] encrypt(String magicCode, String src) throws BiosealException {
        byte[] licenseData = null;
        int[] licenseDataSizeArray = new int[]{-1};
        int err = BiosealLicense.nEncrypt(magicCode, src, licenseData, licenseDataSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            licenseData = new byte[licenseDataSizeArray[0]];
            err = BiosealLicense.nEncrypt(magicCode, src, licenseData, licenseDataSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return licenseData;
    }

    public static String getApplicationHardwareCode(String applicationName, String certificate) throws BiosealException {
        byte[] code = null;
        int[] codeSizeArray = new int[]{-1};
        int err = BiosealLicense.nGetApplicationHardwareCode(applicationName, certificate, code, codeSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            code = new byte[codeSizeArray[0]];
            err = BiosealLicense.nGetApplicationHardwareCode(applicationName, certificate, code, codeSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(code, 0, codeSizeArray[0], Charset.defaultCharset());
    }

    static native int nCheckLicense(String var0);

    static native int nCheckLicenseBuffer(byte[] var0);

    static native int nCheckModule(String var0);

    static native int nGetModuleCount(int[] var0);

    static native int nGetModuleName(int var0, byte[] var1, int[] var2);

    static native int nGetModuleValue(String var0, int[] var1);

    static native int nGetLicenseName(byte[] var0, int[] var1);

    static native int nGetLicenseType(int[] var0);

    static native int nGetLicenseOwner(byte[] var0, int[] var1);

    static native int nGetProductReference(byte[] var0, int[] var1);

    static native int nGetLicensePath(byte[] var0, int[] var1);

    static native int nGetRemainingDays(int[] var0);

    static native int nGetExpiryDate(byte[] var0, int[] var1);

    static native int nGetLicenseFileHardwareCode(byte[] var0, int[] var1);

    static native int nGetLicenseFileSerial(byte[] var0, int[] var1);

    static native int nGetHostHardwareCode(int var0, byte[] var1, int[] var2);

    static native int nGetExternalDriveHardwareCode(int var0, byte[] var1, int[] var2, String var3);

    static native int nGetLicenseComment(byte[] var0, int[] var1);

    static native int nActivate(String var0, String var1, String var2, String var3, String var4, String var5);

    static native int nActivateBuffer(String var0, String var1, String var2, String var3, String var4, byte[] var5, int[] var6);

    static native int nActivateSerialKey(String var0, String var1, String var2, String var3);

    static native int nActivateSerialKeyBuffer(String var0, String var1, String var2, byte[] var3, int[] var4);

    static native int nActivateActivationKey(String var0, String var1, String var2, String var3);

    static native int nActivateActivationKeyBuffer(String var0, String var1, String var2, byte[] var3, int[] var4);

    static native int nReactivate(String var0, String var1, String var2);

    static native int nReactivateBuffer(String var0, String var1, byte[] var2, int[] var3);

    static native int nCheckLicenseWithCard(String var0, byte[] var1, int[] var2);

    static native int nCheckLicenseBufferWithCard(byte[] var0, byte[] var1, int[] var2);

    static native int nFinalizeCheckLicenseWithCard(byte[] var0);

    static native int nEncrypt(String var0, String var1, byte[] var2, int[] var3);

    static native int nGetApplicationHardwareCode(String var0, String var1, byte[] var2, int[] var3);

    static {
        BiosealNative.loadLibraries();
    }
}

