/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import java.io.Serializable;
import java.nio.charset.Charset;

public class CertificateExtension
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public CertificateExtension() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = CertificateExtension.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public CertificateExtension(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            CertificateExtension.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public String getOid() throws BiosealException {
        byte[] oid = null;
        int[] oidSizeArray = new int[]{-1};
        int err = CertificateExtension.nGetOid(this.handle, oid, oidSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            oid = new byte[oidSizeArray[0]];
            err = CertificateExtension.nGetOid(this.handle, oid, oidSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(oid, 0, oidSizeArray[0], Charset.defaultCharset());
    }

    public byte[] getValue() throws BiosealException {
        byte[] value = null;
        int[] valueSizeArray = new int[]{-1};
        int err = CertificateExtension.nGetValue(this.handle, value, valueSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            value = new byte[valueSizeArray[0]];
            err = CertificateExtension.nGetValue(this.handle, value, valueSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return value;
    }

    public boolean getCritical() throws BiosealException {
        boolean[] criticalArray = new boolean[1];
        int err = CertificateExtension.nGetCritical(this.handle, criticalArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return criticalArray[0];
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetOid(long var0, byte[] var2, int[] var3);

    static native int nGetValue(long var0, byte[] var2, int[] var3);

    static native int nGetCritical(long var0, boolean[] var2);

    static {
        BiosealNative.loadLibraries();
    }
}

