/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.CertificateExtension;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CertificateExtensionList
implements AutoCloseable,
Serializable,
Iterable<CertificateExtension> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public CertificateExtensionList() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = CertificateExtensionList.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public CertificateExtensionList(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            CertificateExtensionList.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public CertificateExtension get(int index) throws BiosealException {
        CertificateExtension certificateExtensionItem = new CertificateExtension();
        int err = CertificateExtensionList.nGet(this.handle, index, certificateExtensionItem.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return certificateExtensionItem;
    }

    public int getCount() throws BiosealException {
        int[] countArray = new int[1];
        int err = CertificateExtensionList.nGetCount(this.handle, countArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return countArray[0];
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGet(long var0, int var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    @Override
    public Iterator<CertificateExtension> iterator() {
        return new Iterator<CertificateExtension>(){
            private int index = 0;
            private final int size = CertificateExtensionList.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public CertificateExtension next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return CertificateExtensionList.this.get(this.index++);
            }
        };
    }

    static {
        BiosealNative.loadLibraries();
    }
}

