/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.CertificateExtensionList;
import eu.id3.bioseal.DateTime;
import eu.id3.bioseal.StringArray;
import java.io.Serializable;
import java.nio.charset.Charset;

public class CertificateInformation
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public CertificateInformation() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = CertificateInformation.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public CertificateInformation(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            CertificateInformation.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public String getIssuerCommonName() throws BiosealException {
        byte[] issuerCommonName = null;
        int[] issuerCommonNameSizeArray = new int[]{-1};
        int err = CertificateInformation.nGetIssuerCommonName(this.handle, issuerCommonName, issuerCommonNameSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            issuerCommonName = new byte[issuerCommonNameSizeArray[0]];
            err = CertificateInformation.nGetIssuerCommonName(this.handle, issuerCommonName, issuerCommonNameSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(issuerCommonName, 0, issuerCommonNameSizeArray[0], Charset.defaultCharset());
    }

    public String getIssuerOrganization() throws BiosealException {
        byte[] issuerOrganization = null;
        int[] issuerOrganizationSizeArray = new int[]{-1};
        int err = CertificateInformation.nGetIssuerOrganization(this.handle, issuerOrganization, issuerOrganizationSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            issuerOrganization = new byte[issuerOrganizationSizeArray[0]];
            err = CertificateInformation.nGetIssuerOrganization(this.handle, issuerOrganization, issuerOrganizationSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(issuerOrganization, 0, issuerOrganizationSizeArray[0], Charset.defaultCharset());
    }

    public String getIssuerCountry() throws BiosealException {
        byte[] issuerCountry = null;
        int[] issuerCountrySizeArray = new int[]{-1};
        int err = CertificateInformation.nGetIssuerCountry(this.handle, issuerCountry, issuerCountrySizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            issuerCountry = new byte[issuerCountrySizeArray[0]];
            err = CertificateInformation.nGetIssuerCountry(this.handle, issuerCountry, issuerCountrySizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(issuerCountry, 0, issuerCountrySizeArray[0], Charset.defaultCharset());
    }

    public String getIssuerOrganizationalUnit() throws BiosealException {
        byte[] issuerOrganizationalUnit = null;
        int[] issuerOrganizationalUnitSizeArray = new int[]{-1};
        int err = CertificateInformation.nGetIssuerOrganizationalUnit(this.handle, issuerOrganizationalUnit, issuerOrganizationalUnitSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            issuerOrganizationalUnit = new byte[issuerOrganizationalUnitSizeArray[0]];
            err = CertificateInformation.nGetIssuerOrganizationalUnit(this.handle, issuerOrganizationalUnit, issuerOrganizationalUnitSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(issuerOrganizationalUnit, 0, issuerOrganizationalUnitSizeArray[0], Charset.defaultCharset());
    }

    public String getIssuerDistinguishedName() throws BiosealException {
        byte[] issuerDistinguishedName = null;
        int[] issuerDistinguishedNameSizeArray = new int[]{-1};
        int err = CertificateInformation.nGetIssuerDistinguishedName(this.handle, issuerDistinguishedName, issuerDistinguishedNameSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            issuerDistinguishedName = new byte[issuerDistinguishedNameSizeArray[0]];
            err = CertificateInformation.nGetIssuerDistinguishedName(this.handle, issuerDistinguishedName, issuerDistinguishedNameSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(issuerDistinguishedName, 0, issuerDistinguishedNameSizeArray[0], Charset.defaultCharset());
    }

    public String getSubjectCommonName() throws BiosealException {
        byte[] subjectCommonName = null;
        int[] subjectCommonNameSizeArray = new int[]{-1};
        int err = CertificateInformation.nGetSubjectCommonName(this.handle, subjectCommonName, subjectCommonNameSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            subjectCommonName = new byte[subjectCommonNameSizeArray[0]];
            err = CertificateInformation.nGetSubjectCommonName(this.handle, subjectCommonName, subjectCommonNameSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(subjectCommonName, 0, subjectCommonNameSizeArray[0], Charset.defaultCharset());
    }

    public String getSubjectOrganization() throws BiosealException {
        byte[] subjectOrganization = null;
        int[] subjectOrganizationSizeArray = new int[]{-1};
        int err = CertificateInformation.nGetSubjectOrganization(this.handle, subjectOrganization, subjectOrganizationSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            subjectOrganization = new byte[subjectOrganizationSizeArray[0]];
            err = CertificateInformation.nGetSubjectOrganization(this.handle, subjectOrganization, subjectOrganizationSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(subjectOrganization, 0, subjectOrganizationSizeArray[0], Charset.defaultCharset());
    }

    public String getSubjectCountry() throws BiosealException {
        byte[] subjectCountry = null;
        int[] subjectCountrySizeArray = new int[]{-1};
        int err = CertificateInformation.nGetSubjectCountry(this.handle, subjectCountry, subjectCountrySizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            subjectCountry = new byte[subjectCountrySizeArray[0]];
            err = CertificateInformation.nGetSubjectCountry(this.handle, subjectCountry, subjectCountrySizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(subjectCountry, 0, subjectCountrySizeArray[0], Charset.defaultCharset());
    }

    public String getSubjectOrganizationalUnit() throws BiosealException {
        byte[] subjectOrganizationalUnit = null;
        int[] subjectOrganizationalUnitSizeArray = new int[]{-1};
        int err = CertificateInformation.nGetSubjectOrganizationalUnit(this.handle, subjectOrganizationalUnit, subjectOrganizationalUnitSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            subjectOrganizationalUnit = new byte[subjectOrganizationalUnitSizeArray[0]];
            err = CertificateInformation.nGetSubjectOrganizationalUnit(this.handle, subjectOrganizationalUnit, subjectOrganizationalUnitSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(subjectOrganizationalUnit, 0, subjectOrganizationalUnitSizeArray[0], Charset.defaultCharset());
    }

    public String getSubjectDistinguishedName() throws BiosealException {
        byte[] subjectDistinguishedName = null;
        int[] subjectDistinguishedNameSizeArray = new int[]{-1};
        int err = CertificateInformation.nGetSubjectDistinguishedName(this.handle, subjectDistinguishedName, subjectDistinguishedNameSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            subjectDistinguishedName = new byte[subjectDistinguishedNameSizeArray[0]];
            err = CertificateInformation.nGetSubjectDistinguishedName(this.handle, subjectDistinguishedName, subjectDistinguishedNameSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(subjectDistinguishedName, 0, subjectDistinguishedNameSizeArray[0], Charset.defaultCharset());
    }

    public DateTime getNotBefore() throws BiosealException {
        DateTime notBefore = new DateTime();
        int err = CertificateInformation.nGetNotBefore(this.handle, notBefore.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return notBefore;
    }

    public DateTime getNotAfter() throws BiosealException {
        DateTime notAfter = new DateTime();
        int err = CertificateInformation.nGetNotAfter(this.handle, notAfter.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return notAfter;
    }

    public byte[] getSerialNumber() throws BiosealException {
        byte[] serialNumber = null;
        int[] serialNumberSizeArray = new int[]{-1};
        int err = CertificateInformation.nGetSerialNumber(this.handle, serialNumber, serialNumberSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            serialNumber = new byte[serialNumberSizeArray[0]];
            err = CertificateInformation.nGetSerialNumber(this.handle, serialNumber, serialNumberSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return serialNumber;
    }

    public String getSerialNumberString() throws BiosealException {
        byte[] serialNumberString = null;
        int[] serialNumberStringSizeArray = new int[]{-1};
        int err = CertificateInformation.nGetSerialNumberString(this.handle, serialNumberString, serialNumberStringSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            serialNumberString = new byte[serialNumberStringSizeArray[0]];
            err = CertificateInformation.nGetSerialNumberString(this.handle, serialNumberString, serialNumberStringSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(serialNumberString, 0, serialNumberStringSizeArray[0], Charset.defaultCharset());
    }

    public byte[] getData() throws BiosealException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = CertificateInformation.nGetData(this.handle, data, dataSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = CertificateInformation.nGetData(this.handle, data, dataSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return data;
    }

    public String getSignatureAlgorithm() throws BiosealException {
        byte[] signatureAlgorithm = null;
        int[] signatureAlgorithmSizeArray = new int[]{-1};
        int err = CertificateInformation.nGetSignatureAlgorithm(this.handle, signatureAlgorithm, signatureAlgorithmSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            signatureAlgorithm = new byte[signatureAlgorithmSizeArray[0]];
            err = CertificateInformation.nGetSignatureAlgorithm(this.handle, signatureAlgorithm, signatureAlgorithmSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(signatureAlgorithm, 0, signatureAlgorithmSizeArray[0], Charset.defaultCharset());
    }

    public int getVersion() throws BiosealException {
        int[] versionArray = new int[1];
        int err = CertificateInformation.nGetVersion(this.handle, versionArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return versionArray[0];
    }

    public byte[] getPublicKey() throws BiosealException {
        byte[] publicKey = null;
        int[] publicKeySizeArray = new int[]{-1};
        int err = CertificateInformation.nGetPublicKey(this.handle, publicKey, publicKeySizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            publicKey = new byte[publicKeySizeArray[0]];
            err = CertificateInformation.nGetPublicKey(this.handle, publicKey, publicKeySizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return publicKey;
    }

    public StringArray getKeyUsage() throws BiosealException {
        StringArray keyUsage = new StringArray();
        int err = CertificateInformation.nGetKeyUsage(this.handle, keyUsage.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return keyUsage;
    }

    public StringArray getPolicies() throws BiosealException {
        StringArray policies = new StringArray();
        int err = CertificateInformation.nGetPolicies(this.handle, policies.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return policies;
    }

    public CertificateExtensionList getCertificateExtensionList() throws BiosealException {
        CertificateExtensionList certificateExtensionList = new CertificateExtensionList();
        int err = CertificateInformation.nGetCertificateExtensionList(this.handle, certificateExtensionList.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return certificateExtensionList;
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetIssuerCommonName(long var0, byte[] var2, int[] var3);

    static native int nGetIssuerOrganization(long var0, byte[] var2, int[] var3);

    static native int nGetIssuerCountry(long var0, byte[] var2, int[] var3);

    static native int nGetIssuerOrganizationalUnit(long var0, byte[] var2, int[] var3);

    static native int nGetIssuerDistinguishedName(long var0, byte[] var2, int[] var3);

    static native int nGetSubjectCommonName(long var0, byte[] var2, int[] var3);

    static native int nGetSubjectOrganization(long var0, byte[] var2, int[] var3);

    static native int nGetSubjectCountry(long var0, byte[] var2, int[] var3);

    static native int nGetSubjectOrganizationalUnit(long var0, byte[] var2, int[] var3);

    static native int nGetSubjectDistinguishedName(long var0, byte[] var2, int[] var3);

    static native int nGetNotBefore(long var0, long var2);

    static native int nGetNotAfter(long var0, long var2);

    static native int nGetSerialNumber(long var0, byte[] var2, int[] var3);

    static native int nGetSerialNumberString(long var0, byte[] var2, int[] var3);

    static native int nGetData(long var0, byte[] var2, int[] var3);

    static native int nGetSignatureAlgorithm(long var0, byte[] var2, int[] var3);

    static native int nGetVersion(long var0, int[] var2);

    static native int nGetPublicKey(long var0, byte[] var2, int[] var3);

    static native int nGetKeyUsage(long var0, long var2);

    static native int nGetPolicies(long var0, long var2);

    static native int nGetCertificateExtensionList(long var0, long var2);

    static {
        BiosealNative.loadLibraries();
    }
}

