/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import java.io.Serializable;
import java.nio.charset.Charset;

public class DateTime
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public DateTime() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = DateTime.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public DateTime(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            DateTime.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public int getYear() throws BiosealException {
        int[] yearArray = new int[1];
        int err = DateTime.nGetYear(this.handle, yearArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return yearArray[0];
    }

    public int getMonth() throws BiosealException {
        int[] monthArray = new int[1];
        int err = DateTime.nGetMonth(this.handle, monthArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return monthArray[0];
    }

    public int getDay() throws BiosealException {
        int[] dayArray = new int[1];
        int err = DateTime.nGetDay(this.handle, dayArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return dayArray[0];
    }

    public int getHour() throws BiosealException {
        int[] hourArray = new int[1];
        int err = DateTime.nGetHour(this.handle, hourArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return hourArray[0];
    }

    public int getMinute() throws BiosealException {
        int[] minuteArray = new int[1];
        int err = DateTime.nGetMinute(this.handle, minuteArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return minuteArray[0];
    }

    public int getSecond() throws BiosealException {
        int[] secondArray = new int[1];
        int err = DateTime.nGetSecond(this.handle, secondArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return secondArray[0];
    }

    public boolean isValid() throws BiosealException {
        boolean[] resultArray = new boolean[1];
        int err = DateTime.nIsValid(this.handle, resultArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultArray[0];
    }

    public boolean isTimeValid() throws BiosealException {
        boolean[] resultArray = new boolean[1];
        int err = DateTime.nIsTimeValid(this.handle, resultArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultArray[0];
    }

    public boolean isDateValid() throws BiosealException {
        boolean[] resultArray = new boolean[1];
        int err = DateTime.nIsDateValid(this.handle, resultArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultArray[0];
    }

    public boolean isDateTimeValid() throws BiosealException {
        boolean[] resultArray = new boolean[1];
        int err = DateTime.nIsDateTimeValid(this.handle, resultArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultArray[0];
    }

    public String toString() throws BiosealException {
        byte[] result = null;
        int[] resultSizeArray = new int[]{-1};
        int err = DateTime.nToString(this.handle, result, resultSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            result = new byte[resultSizeArray[0]];
            err = DateTime.nToString(this.handle, result, resultSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(result, 0, resultSizeArray[0], Charset.defaultCharset());
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetYear(long var0, int[] var2);

    static native int nGetMonth(long var0, int[] var2);

    static native int nGetDay(long var0, int[] var2);

    static native int nGetHour(long var0, int[] var2);

    static native int nGetMinute(long var0, int[] var2);

    static native int nGetSecond(long var0, int[] var2);

    static native int nIsValid(long var0, boolean[] var2);

    static native int nIsTimeValid(long var0, boolean[] var2);

    static native int nIsDateValid(long var0, boolean[] var2);

    static native int nIsDateTimeValid(long var0, boolean[] var2);

    static native int nToString(long var0, byte[] var2, int[] var3);

    static {
        BiosealNative.loadLibraries();
    }
}

