/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.DateTime;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DateTimeArray
implements AutoCloseable,
Serializable,
Iterable<DateTime> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public DateTimeArray() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = DateTimeArray.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public DateTimeArray(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            DateTimeArray.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public DateTime get(int index) throws BiosealException {
        DateTime dateTimeItem = new DateTime();
        int err = DateTimeArray.nGet(this.handle, index, dateTimeItem.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return dateTimeItem;
    }

    public int getCount() throws BiosealException {
        int[] countArray = new int[1];
        int err = DateTimeArray.nGetCount(this.handle, countArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return countArray[0];
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGet(long var0, int var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    @Override
    public Iterator<DateTime> iterator() {
        return new Iterator<DateTime>(){
            private int index = 0;
            private final int size = DateTimeArray.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public DateTime next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return DateTimeArray.this.get(this.index++);
            }
        };
    }

    static {
        BiosealNative.loadLibraries();
    }
}

