/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.StringArray;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Extension
implements AutoCloseable,
Serializable,
Iterable<String> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public Extension() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = Extension.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public Extension(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            Extension.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public String getName() throws BiosealException {
        byte[] name = null;
        int[] nameSizeArray = new int[]{-1};
        int err = Extension.nGetName(this.handle, name, nameSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            name = new byte[nameSizeArray[0]];
            err = Extension.nGetName(this.handle, name, nameSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(name, 0, nameSizeArray[0], Charset.defaultCharset());
    }

    public StringArray getKeys() throws BiosealException {
        StringArray keys = new StringArray();
        int err = Extension.nGetKeys(this.handle, keys.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return keys;
    }

    public String get(String key) throws BiosealException {
        byte[] item = null;
        int[] itemSizeArray = new int[]{-1};
        int err = Extension.nGet(this.handle, key, item, itemSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            item = new byte[itemSizeArray[0]];
            err = Extension.nGet(this.handle, key, item, itemSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(item, 0, itemSizeArray[0], Charset.defaultCharset());
    }

    public int getCount() throws BiosealException {
        int[] countArray = new int[1];
        int err = Extension.nGetCount(this.handle, countArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return countArray[0];
    }

    public boolean containsKey(String key) throws BiosealException {
        boolean[] resultArray = new boolean[1];
        int err = Extension.nContainsKey(this.handle, key, resultArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultArray[0];
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetName(long var0, byte[] var2, int[] var3);

    static native int nGetKeys(long var0, long var2);

    static native int nGet(long var0, String var2, byte[] var3, int[] var4);

    static native int nGetCount(long var0, int[] var2);

    static native int nContainsKey(long var0, String var2, boolean[] var3);

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int index = 0;
            private final StringArray keyList = Extension.this.getKeys();
            private final int size = Extension.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Extension.this.get(this.keyList.get(this.index++));
            }
        };
    }

    static {
        BiosealNative.loadLibraries();
    }
}

