/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.Extension;
import eu.id3.bioseal.StringArray;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ExtensionList
implements AutoCloseable,
Serializable,
Iterable<Extension> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public ExtensionList() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = ExtensionList.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public ExtensionList(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            ExtensionList.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public StringArray getKeys() throws BiosealException {
        StringArray keys = new StringArray();
        int err = ExtensionList.nGetKeys(this.handle, keys.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return keys;
    }

    public Extension get(String key) throws BiosealException {
        Extension extensionItem = new Extension();
        int err = ExtensionList.nGet(this.handle, key, extensionItem.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return extensionItem;
    }

    public int getCount() throws BiosealException {
        int[] countArray = new int[1];
        int err = ExtensionList.nGetCount(this.handle, countArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return countArray[0];
    }

    public boolean containsKey(String key) throws BiosealException {
        boolean[] resultArray = new boolean[1];
        int err = ExtensionList.nContainsKey(this.handle, key, resultArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultArray[0];
    }

    public void clear() throws BiosealException {
        int err = ExtensionList.nClear(this.handle);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetKeys(long var0, long var2);

    static native int nGet(long var0, String var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nContainsKey(long var0, String var2, boolean[] var3);

    static native int nClear(long var0);

    @Override
    public Iterator<Extension> iterator() {
        return new Iterator<Extension>(){
            private int index = 0;
            private final StringArray keyList = ExtensionList.this.getKeys();
            private final int size = ExtensionList.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Extension next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ExtensionList.this.get(this.keyList.get(this.index++));
            }
        };
    }

    static {
        BiosealNative.loadLibraries();
    }
}

