/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiometricDataType;
import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.DateTime;
import eu.id3.bioseal.DateTimeArray;
import eu.id3.bioseal.Extension;
import eu.id3.bioseal.FieldExtensionType;
import eu.id3.bioseal.FieldType;
import eu.id3.bioseal.StringArray;
import eu.id3.bioseal.VisibilityCondition;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Field
implements AutoCloseable,
Serializable,
Iterable<Field> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public Field() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = Field.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public Field(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            Field.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public FieldType getFieldType() throws BiosealException {
        int[] fieldTypeArray = new int[1];
        int err = Field.nGetFieldType(this.handle, fieldTypeArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return FieldType.fromValue(fieldTypeArray[0]);
    }

    public String getName() throws BiosealException {
        byte[] name = null;
        int[] nameSizeArray = new int[]{-1};
        int err = Field.nGetName(this.handle, name, nameSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            name = new byte[nameSizeArray[0]];
            err = Field.nGetName(this.handle, name, nameSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(name, 0, nameSizeArray[0], Charset.defaultCharset());
    }

    public long getValueAsInteger() throws BiosealException {
        long[] valueAsIntegerArray = new long[1];
        int err = Field.nGetValueAsInteger(this.handle, valueAsIntegerArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueAsIntegerArray[0];
    }

    public boolean getValueAsBoolean() throws BiosealException {
        boolean[] valueAsBooleanArray = new boolean[1];
        int err = Field.nGetValueAsBoolean(this.handle, valueAsBooleanArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueAsBooleanArray[0];
    }

    public float getValueAsFloat() throws BiosealException {
        float[] valueAsFloatArray = new float[1];
        int err = Field.nGetValueAsFloat(this.handle, valueAsFloatArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueAsFloatArray[0];
    }

    public String getValueAsString() throws BiosealException {
        byte[] valueAsString = null;
        int[] valueAsStringSizeArray = new int[]{-1};
        int err = Field.nGetValueAsString(this.handle, valueAsString, valueAsStringSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            valueAsString = new byte[valueAsStringSizeArray[0]];
            err = Field.nGetValueAsString(this.handle, valueAsString, valueAsStringSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(valueAsString, 0, valueAsStringSizeArray[0], Charset.defaultCharset());
    }

    public byte[] getValueAsBinary() throws BiosealException {
        byte[] valueAsBinary = null;
        int[] valueAsBinarySizeArray = new int[]{-1};
        int err = Field.nGetValueAsBinary(this.handle, valueAsBinary, valueAsBinarySizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            valueAsBinary = new byte[valueAsBinarySizeArray[0]];
            err = Field.nGetValueAsBinary(this.handle, valueAsBinary, valueAsBinarySizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueAsBinary;
    }

    public DateTime getValueAsDate() throws BiosealException {
        DateTime valueAsDate = new DateTime();
        int err = Field.nGetValueAsDate(this.handle, valueAsDate.getHandle());
        if (err == BiosealError.OBJECT_DOES_NOT_EXIST.getValue()) {
            return null;
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueAsDate;
    }

    public DateTime getValueAsTime() throws BiosealException {
        DateTime valueAsTime = new DateTime();
        int err = Field.nGetValueAsTime(this.handle, valueAsTime.getHandle());
        if (err == BiosealError.OBJECT_DOES_NOT_EXIST.getValue()) {
            return null;
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueAsTime;
    }

    public DateTime getValueAsDateTime() throws BiosealException {
        DateTime valueAsDateTime = new DateTime();
        int err = Field.nGetValueAsDateTime(this.handle, valueAsDateTime.getHandle());
        if (err == BiosealError.OBJECT_DOES_NOT_EXIST.getValue()) {
            return null;
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueAsDateTime;
    }

    public long getValueAsTimestamp() throws BiosealException {
        long[] valueAsTimestampArray = new long[1];
        int err = Field.nGetValueAsTimestamp(this.handle, valueAsTimestampArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueAsTimestampArray[0];
    }

    public long[] getValueAsIntegerArray() throws BiosealException {
        long[] valueAsIntegerArray = null;
        int[] valueAsIntegerArraySizeArray = new int[]{-1};
        int err = Field.nGetValueAsIntegerArray(this.handle, valueAsIntegerArray, valueAsIntegerArraySizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            valueAsIntegerArray = new long[valueAsIntegerArraySizeArray[0]];
            err = Field.nGetValueAsIntegerArray(this.handle, valueAsIntegerArray, valueAsIntegerArraySizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueAsIntegerArray;
    }

    public boolean[] getValueAsBooleanArray() throws BiosealException {
        boolean[] valueAsBooleanArray = null;
        int[] valueAsBooleanArraySizeArray = new int[]{-1};
        int err = Field.nGetValueAsBooleanArray(this.handle, valueAsBooleanArray, valueAsBooleanArraySizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            valueAsBooleanArray = new boolean[valueAsBooleanArraySizeArray[0]];
            err = Field.nGetValueAsBooleanArray(this.handle, valueAsBooleanArray, valueAsBooleanArraySizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueAsBooleanArray;
    }

    public float[] getValueAsFloatArray() throws BiosealException {
        float[] valueAsFloatArray = null;
        int[] valueAsFloatArraySizeArray = new int[]{-1};
        int err = Field.nGetValueAsFloatArray(this.handle, valueAsFloatArray, valueAsFloatArraySizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            valueAsFloatArray = new float[valueAsFloatArraySizeArray[0]];
            err = Field.nGetValueAsFloatArray(this.handle, valueAsFloatArray, valueAsFloatArraySizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueAsFloatArray;
    }

    public StringArray getValueAsStringArray() throws BiosealException {
        StringArray valueAsStringArray = new StringArray();
        int err = Field.nGetValueAsStringArray(this.handle, valueAsStringArray.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueAsStringArray;
    }

    public DateTimeArray getValueAsDateTimeArray() throws BiosealException {
        DateTimeArray valueAsDateTimeArray = new DateTimeArray();
        int err = Field.nGetValueAsDateTimeArray(this.handle, valueAsDateTimeArray.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueAsDateTimeArray;
    }

    public long[] getValueAsTimestampArray() throws BiosealException {
        long[] valueAsTimestampArray = null;
        int[] valueAsTimestampArraySizeArray = new int[]{-1};
        int err = Field.nGetValueAsTimestampArray(this.handle, valueAsTimestampArray, valueAsTimestampArraySizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            valueAsTimestampArray = new long[valueAsTimestampArraySizeArray[0]];
            err = Field.nGetValueAsTimestampArray(this.handle, valueAsTimestampArray, valueAsTimestampArraySizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return valueAsTimestampArray;
    }

    public boolean getIsNull() throws BiosealException {
        boolean[] isNullArray = new boolean[1];
        int err = Field.nGetIsNull(this.handle, isNullArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return isNullArray[0];
    }

    public boolean getContainsBiometrics() throws BiosealException {
        boolean[] containsBiometricsArray = new boolean[1];
        int err = Field.nGetContainsBiometrics(this.handle, containsBiometricsArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return containsBiometricsArray[0];
    }

    public FieldExtensionType getExtensionType() throws BiosealException {
        int[] extensionTypeArray = new int[1];
        int err = Field.nGetExtensionType(this.handle, extensionTypeArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return FieldExtensionType.fromValue(extensionTypeArray[0]);
    }

    public Extension getFieldExtension() throws BiosealException {
        Extension fieldExtension = new Extension();
        int err = Field.nGetFieldExtension(this.handle, fieldExtension.getHandle());
        if (err == BiosealError.OBJECT_DOES_NOT_EXIST.getValue()) {
            return null;
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return fieldExtension;
    }

    public VisibilityCondition getVisibilityCondition() throws BiosealException {
        int[] visibilityConditionArray = new int[1];
        int err = Field.nGetVisibilityCondition(this.handle, visibilityConditionArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return VisibilityCondition.fromValue(visibilityConditionArray[0]);
    }

    public StringArray getKeys() throws BiosealException {
        StringArray keys = new StringArray();
        int err = Field.nGetKeys(this.handle, keys.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return keys;
    }

    public Field get(String key) throws BiosealException {
        Field fieldItem = new Field();
        int err = Field.nGet(this.handle, key, fieldItem.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return fieldItem;
    }

    public int getCount() throws BiosealException {
        int[] countArray = new int[1];
        int err = Field.nGetCount(this.handle, countArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return countArray[0];
    }

    public boolean containsKey(String key) throws BiosealException {
        boolean[] resultArray = new boolean[1];
        int err = Field.nContainsKey(this.handle, key, resultArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultArray[0];
    }

    public Field getObjectAtIndex(int index) throws BiosealException {
        Field item = new Field();
        int err = Field.nGetObjectAtIndex(this.handle, index, item.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return item;
    }

    public byte[] getBinaryAtIndex(int index) throws BiosealException {
        byte[] item = null;
        int[] itemSizeArray = new int[]{-1};
        int err = Field.nGetBinaryAtIndex(this.handle, index, item, itemSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            item = new byte[itemSizeArray[0]];
            err = Field.nGetBinaryAtIndex(this.handle, index, item, itemSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return item;
    }

    public void setTimeZoneOffset(int offsetInSeconds) throws BiosealException {
        int err = Field.nSetTimeZoneOffset(this.handle, offsetInSeconds);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public boolean containsExtension(FieldExtensionType extensionType) throws BiosealException {
        boolean[] resultArray = new boolean[1];
        int err = Field.nContainsExtension(this.handle, extensionType.getValue(), resultArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultArray[0];
    }

    public boolean containsExtensionByName(String extensionName) throws BiosealException {
        boolean[] resultArray = new boolean[1];
        int err = Field.nContainsExtensionByName(this.handle, extensionName, resultArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultArray[0];
    }

    public boolean containsBiometricData(BiometricDataType biometricDataType, String biometricFormat) throws BiosealException {
        boolean[] resultArray = new boolean[1];
        int err = Field.nContainsBiometricData(this.handle, biometricDataType.getValue(), biometricFormat, resultArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultArray[0];
    }

    public String getLocalizedLabel(String language) throws BiosealException {
        byte[] label = null;
        int[] labelSizeArray = new int[]{-1};
        int err = Field.nGetLocalizedLabel(this.handle, language, label, labelSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            label = new byte[labelSizeArray[0]];
            err = Field.nGetLocalizedLabel(this.handle, language, label, labelSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(label, 0, labelSizeArray[0], Charset.defaultCharset());
    }

    public String getLocalizedValue(String language) throws BiosealException {
        byte[] value = null;
        int[] valueSizeArray = new int[]{-1};
        int err = Field.nGetLocalizedValue(this.handle, language, value, valueSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            value = new byte[valueSizeArray[0]];
            err = Field.nGetLocalizedValue(this.handle, language, value, valueSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(value, 0, valueSizeArray[0], Charset.defaultCharset());
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetFieldType(long var0, int[] var2);

    static native int nGetName(long var0, byte[] var2, int[] var3);

    static native int nGetValueAsInteger(long var0, long[] var2);

    static native int nGetValueAsBoolean(long var0, boolean[] var2);

    static native int nGetValueAsFloat(long var0, float[] var2);

    static native int nGetValueAsString(long var0, byte[] var2, int[] var3);

    static native int nGetValueAsBinary(long var0, byte[] var2, int[] var3);

    static native int nGetValueAsDate(long var0, long var2);

    static native int nGetValueAsTime(long var0, long var2);

    static native int nGetValueAsDateTime(long var0, long var2);

    static native int nGetValueAsTimestamp(long var0, long[] var2);

    static native int nGetValueAsIntegerArray(long var0, long[] var2, int[] var3);

    static native int nGetValueAsBooleanArray(long var0, boolean[] var2, int[] var3);

    static native int nGetValueAsFloatArray(long var0, float[] var2, int[] var3);

    static native int nGetValueAsStringArray(long var0, long var2);

    static native int nGetValueAsDateTimeArray(long var0, long var2);

    static native int nGetValueAsTimestampArray(long var0, long[] var2, int[] var3);

    static native int nGetIsNull(long var0, boolean[] var2);

    static native int nGetContainsBiometrics(long var0, boolean[] var2);

    static native int nGetExtensionType(long var0, int[] var2);

    static native int nGetFieldExtension(long var0, long var2);

    static native int nGetVisibilityCondition(long var0, int[] var2);

    static native int nGetKeys(long var0, long var2);

    static native int nGet(long var0, String var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nContainsKey(long var0, String var2, boolean[] var3);

    static native int nGetObjectAtIndex(long var0, int var2, long var3);

    static native int nGetBinaryAtIndex(long var0, int var2, byte[] var3, int[] var4);

    static native int nSetTimeZoneOffset(long var0, int var2);

    static native int nContainsExtension(long var0, int var2, boolean[] var3);

    static native int nContainsExtensionByName(long var0, String var2, boolean[] var3);

    static native int nContainsBiometricData(long var0, int var2, String var3, boolean[] var4);

    static native int nGetLocalizedLabel(long var0, String var2, byte[] var3, int[] var4);

    static native int nGetLocalizedValue(long var0, String var2, byte[] var3, int[] var4);

    @Override
    public Iterator<Field> iterator() {
        return new Iterator<Field>(){
            private int index = 0;
            private final StringArray keyList = Field.this.getKeys();
            private final int size = Field.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Field next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Field.this.get(this.keyList.get(this.index++));
            }
        };
    }

    static {
        BiosealNative.loadLibraries();
    }
}

