/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.Field;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FieldList
implements AutoCloseable,
Serializable,
Iterable<Field> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public FieldList() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = FieldList.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public FieldList(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            FieldList.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public Field get(int index) throws BiosealException {
        Field fieldItem = new Field();
        int err = FieldList.nGet(this.handle, index, fieldItem.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return fieldItem;
    }

    public int getCount() throws BiosealException {
        int[] countArray = new int[1];
        int err = FieldList.nGetCount(this.handle, countArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return countArray[0];
    }

    public void clear() throws BiosealException {
        int err = FieldList.nClear(this.handle);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGet(long var0, int var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nClear(long var0);

    @Override
    public Iterator<Field> iterator() {
        return new Iterator<Field>(){
            private int index = 0;
            private final int size = FieldList.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Field next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return FieldList.this.get(this.index++);
            }
        };
    }

    static {
        BiosealNative.loadLibraries();
    }
}

