/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.LogItem;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Log
implements AutoCloseable,
Serializable,
Iterable<LogItem> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public Log() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = Log.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public Log(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            Log.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public LogItem get(int index) throws BiosealException {
        LogItem logItemItem = new LogItem();
        int err = Log.nGet(this.handle, index, logItemItem.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return logItemItem;
    }

    public int getCount() throws BiosealException {
        int[] countArray = new int[1];
        int err = Log.nGetCount(this.handle, countArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return countArray[0];
    }

    public String exportToJson(String indentation, boolean debug) throws BiosealException {
        byte[] result = null;
        int[] resultSizeArray = new int[]{-1};
        int err = Log.nExportToJson(this.handle, indentation, debug, result, resultSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            result = new byte[resultSizeArray[0]];
            err = Log.nExportToJson(this.handle, indentation, debug, result, resultSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(result, 0, resultSizeArray[0], Charset.defaultCharset());
    }

    public String exportToHtml(boolean debug) throws BiosealException {
        byte[] result = null;
        int[] resultSizeArray = new int[]{-1};
        int err = Log.nExportToHtml(this.handle, debug, result, resultSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            result = new byte[resultSizeArray[0]];
            err = Log.nExportToHtml(this.handle, debug, result, resultSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(result, 0, resultSizeArray[0], Charset.defaultCharset());
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGet(long var0, int var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nExportToJson(long var0, String var2, boolean var3, byte[] var4, int[] var5);

    static native int nExportToHtml(long var0, boolean var2, byte[] var3, int[] var4);

    @Override
    public Iterator<LogItem> iterator() {
        return new Iterator<LogItem>(){
            private int index = 0;
            private final int size = Log.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public LogItem next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Log.this.get(this.index++);
            }
        };
    }

    static {
        BiosealNative.loadLibraries();
    }
}

