/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.LogItemType;
import java.io.Serializable;
import java.nio.charset.Charset;

public class LogItem
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public LogItem() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = LogItem.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public LogItem(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            LogItem.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public long getTimestamp() throws BiosealException {
        long[] timestampArray = new long[1];
        int err = LogItem.nGetTimestamp(this.handle, timestampArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return timestampArray[0];
    }

    public String getMessage() throws BiosealException {
        byte[] message = null;
        int[] messageSizeArray = new int[]{-1};
        int err = LogItem.nGetMessage(this.handle, message, messageSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            message = new byte[messageSizeArray[0]];
            err = LogItem.nGetMessage(this.handle, message, messageSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(message, 0, messageSizeArray[0], Charset.defaultCharset());
    }

    public LogItemType getItemType() throws BiosealException {
        int[] itemTypeArray = new int[1];
        int err = LogItem.nGetItemType(this.handle, itemTypeArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return LogItemType.fromValue(itemTypeArray[0]);
    }

    public BiosealError getErrorCode() throws BiosealException {
        int[] errorCodeArray = new int[1];
        int err = LogItem.nGetErrorCode(this.handle, errorCodeArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return BiosealError.fromValue(errorCodeArray[0]);
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetTimestamp(long var0, long[] var2);

    static native int nGetMessage(long var0, byte[] var2, int[] var3);

    static native int nGetItemType(long var0, int[] var2);

    static native int nGetErrorCode(long var0, int[] var2);

    static {
        BiosealNative.loadLibraries();
    }
}

