/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.Log;
import java.io.Serializable;
import java.nio.charset.Charset;

public class Lotl
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public Lotl() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = Lotl.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public Lotl(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            Lotl.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public Log getLog() throws BiosealException {
        Log log = new Log();
        int err = Lotl.nGetLog(this.handle, log.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return log;
    }

    public boolean getIsTsl() throws BiosealException {
        boolean[] isTslArray = new boolean[1];
        int err = Lotl.nGetIsTsl(this.handle, isTslArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return isTslArray[0];
    }

    public String getUrl(byte[] lotlData, String manifestId, String iac) throws BiosealException {
        byte[] url = null;
        int[] urlSizeArray = new int[]{-1};
        int err = Lotl.nGetUrl(this.handle, lotlData, manifestId, iac, url, urlSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            url = new byte[urlSizeArray[0]];
            err = Lotl.nGetUrl(this.handle, lotlData, manifestId, iac, url, urlSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(url, 0, urlSizeArray[0], Charset.defaultCharset());
    }

    public String getManifestUrl(byte[] tslData) throws BiosealException {
        byte[] url = null;
        int[] urlSizeArray = new int[]{-1};
        int err = Lotl.nGetManifestUrl(this.handle, tslData, url, urlSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            url = new byte[urlSizeArray[0]];
            err = Lotl.nGetManifestUrl(this.handle, tslData, url, urlSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(url, 0, urlSizeArray[0], Charset.defaultCharset());
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetLog(long var0, long var2);

    static native int nGetIsTsl(long var0, boolean[] var2);

    static native int nGetUrl(long var0, byte[] var2, String var3, String var4, byte[] var5, int[] var6);

    static native int nGetManifestUrl(long var0, byte[] var2, byte[] var3, int[] var4);

    static {
        BiosealNative.loadLibraries();
    }
}

