/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.ExtensionList;
import eu.id3.bioseal.Log;
import eu.id3.bioseal.StringArray;
import java.io.Serializable;
import java.nio.charset.Charset;

public class Manifest
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public Manifest() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = Manifest.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public Manifest(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            Manifest.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public int getManifestId() throws BiosealException {
        int[] manifestIdArray = new int[1];
        int err = Manifest.nGetManifestId(this.handle, manifestIdArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return manifestIdArray[0];
    }

    public int getManifestVersion() throws BiosealException {
        int[] manifestVersionArray = new int[1];
        int err = Manifest.nGetManifestVersion(this.handle, manifestVersionArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return manifestVersionArray[0];
    }

    public StringArray getSupportedLanguages() throws BiosealException {
        StringArray supportedLanguages = new StringArray();
        int err = Manifest.nGetSupportedLanguages(this.handle, supportedLanguages.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return supportedLanguages;
    }

    public ExtensionList getExtensionList() throws BiosealException {
        ExtensionList extensionList = new ExtensionList();
        int err = Manifest.nGetExtensionList(this.handle, extensionList.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return extensionList;
    }

    public Log getLog() throws BiosealException {
        Log log = new Log();
        int err = Manifest.nGetLog(this.handle, log.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return log;
    }

    public void setLog(Log log) throws BiosealException {
        int err = Manifest.nSetLog(this.handle, log.getHandle());
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public void load(byte[] manifestData) throws BiosealException {
        int err = Manifest.nLoad(this.handle, manifestData);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public void loadFromString(String manifestData) throws BiosealException {
        int err = Manifest.nLoadFromString(this.handle, manifestData);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public void loadFromFile(String path) throws BiosealException {
        int err = Manifest.nLoadFromFile(this.handle, path);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public String getDocumentName(String language) throws BiosealException {
        byte[] documentName = null;
        int[] documentNameSizeArray = new int[]{-1};
        int err = Manifest.nGetDocumentName(this.handle, language, documentName, documentNameSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            documentName = new byte[documentNameSizeArray[0]];
            err = Manifest.nGetDocumentName(this.handle, language, documentName, documentNameSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(documentName, 0, documentNameSizeArray[0], Charset.defaultCharset());
    }

    public String getDocumentDescription(String language) throws BiosealException {
        byte[] documentDescription = null;
        int[] documentDescriptionSizeArray = new int[]{-1};
        int err = Manifest.nGetDocumentDescription(this.handle, language, documentDescription, documentDescriptionSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            documentDescription = new byte[documentDescriptionSizeArray[0]];
            err = Manifest.nGetDocumentDescription(this.handle, language, documentDescription, documentDescriptionSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(documentDescription, 0, documentDescriptionSizeArray[0], Charset.defaultCharset());
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetManifestId(long var0, int[] var2);

    static native int nGetManifestVersion(long var0, int[] var2);

    static native int nGetSupportedLanguages(long var0, long var2);

    static native int nGetExtensionList(long var0, long var2);

    static native int nGetLog(long var0, long var2);

    static native int nSetLog(long var0, long var2);

    static native int nLoad(long var0, byte[] var2);

    static native int nLoadFromString(long var0, String var2);

    static native int nLoadFromFile(long var0, String var2);

    static native int nGetDocumentName(long var0, String var2, byte[] var3, int[] var4);

    static native int nGetDocumentDescription(long var0, String var2, byte[] var3, int[] var4);

    static {
        BiosealNative.loadLibraries();
    }
}

