/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.ResourceType;
import java.io.Serializable;
import java.nio.charset.Charset;

public class ResourceCallbackArgs
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public ResourceCallbackArgs() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = ResourceCallbackArgs.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public ResourceCallbackArgs(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            ResourceCallbackArgs.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public String getUri() throws BiosealException {
        byte[] uri = null;
        int[] uriSizeArray = new int[]{-1};
        int err = ResourceCallbackArgs.nGetUri(this.handle, uri, uriSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            uri = new byte[uriSizeArray[0]];
            err = ResourceCallbackArgs.nGetUri(this.handle, uri, uriSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(uri, 0, uriSizeArray[0], Charset.defaultCharset());
    }

    public String getResourceName() throws BiosealException {
        byte[] resourceName = null;
        int[] resourceNameSizeArray = new int[]{-1};
        int err = ResourceCallbackArgs.nGetResourceName(this.handle, resourceName, resourceNameSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            resourceName = new byte[resourceNameSizeArray[0]];
            err = ResourceCallbackArgs.nGetResourceName(this.handle, resourceName, resourceNameSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(resourceName, 0, resourceNameSizeArray[0], Charset.defaultCharset());
    }

    public ResourceType getResourceType() throws BiosealException {
        int[] resourceTypeArray = new int[1];
        int err = ResourceCallbackArgs.nGetResourceType(this.handle, resourceTypeArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return ResourceType.fromValue(resourceTypeArray[0]);
    }

    public boolean getRequiresUpdate() throws BiosealException {
        boolean[] requiresUpdateArray = new boolean[1];
        int err = ResourceCallbackArgs.nGetRequiresUpdate(this.handle, requiresUpdateArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return requiresUpdateArray[0];
    }

    public byte[] getOutputData() throws BiosealException {
        byte[] outputData = null;
        int[] outputDataSizeArray = new int[]{-1};
        int err = ResourceCallbackArgs.nGetOutputData(this.handle, outputData, outputDataSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            outputData = new byte[outputDataSizeArray[0]];
            err = ResourceCallbackArgs.nGetOutputData(this.handle, outputData, outputDataSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return outputData;
    }

    public void setOutputData(byte[] outputData) throws BiosealException {
        int err = ResourceCallbackArgs.nSetOutputData(this.handle, outputData);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public void download() throws BiosealException {
        int err = ResourceCallbackArgs.nDownload(this.handle);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
    }

    public String downloadStringFile(String url) throws BiosealException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = ResourceCallbackArgs.nDownloadStringFile(this.handle, url, data, dataSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = ResourceCallbackArgs.nDownloadStringFile(this.handle, url, data, dataSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(data, 0, dataSizeArray[0], Charset.defaultCharset());
    }

    public String computeSha256() throws BiosealException {
        byte[] result = null;
        int[] resultSizeArray = new int[]{-1};
        int err = ResourceCallbackArgs.nComputeSha256(this.handle, result, resultSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            result = new byte[resultSizeArray[0]];
            err = ResourceCallbackArgs.nComputeSha256(this.handle, result, resultSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(result, 0, resultSizeArray[0], Charset.defaultCharset());
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetUri(long var0, byte[] var2, int[] var3);

    static native int nGetResourceName(long var0, byte[] var2, int[] var3);

    static native int nGetResourceType(long var0, int[] var2);

    static native int nGetRequiresUpdate(long var0, boolean[] var2);

    static native int nGetOutputData(long var0, byte[] var2, int[] var3);

    static native int nSetOutputData(long var0, byte[] var2);

    static native int nDownload(long var0);

    static native int nDownloadStringFile(long var0, String var2, byte[] var3, int[] var4);

    static native int nComputeSha256(long var0, byte[] var2, int[] var3);

    static {
        BiosealNative.loadLibraries();
    }
}

