/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StringArray
implements AutoCloseable,
Serializable,
Iterable<String> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public StringArray() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = StringArray.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public StringArray(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            StringArray.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public String get(int index) throws BiosealException {
        byte[] item = null;
        int[] itemSizeArray = new int[]{-1};
        int err = StringArray.nGet(this.handle, index, item, itemSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            item = new byte[itemSizeArray[0]];
            err = StringArray.nGet(this.handle, index, item, itemSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(item, 0, itemSizeArray[0], Charset.defaultCharset());
    }

    public int getCount() throws BiosealException {
        int[] countArray = new int[1];
        int err = StringArray.nGetCount(this.handle, countArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return countArray[0];
    }

    public boolean contains(String item) throws BiosealException {
        boolean[] resultArray = new boolean[1];
        int err = StringArray.nContains(this.handle, item, resultArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return resultArray[0];
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGet(long var0, int var2, byte[] var3, int[] var4);

    static native int nGetCount(long var0, int[] var2);

    static native int nContains(long var0, String var2, boolean[] var3);

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int index = 0;
            private final int size = StringArray.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return StringArray.this.get(this.index++);
            }
        };
    }

    static {
        BiosealNative.loadLibraries();
    }
}

