/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.bioseal;

import eu.id3.bioseal.BiosealError;
import eu.id3.bioseal.BiosealException;
import eu.id3.bioseal.BiosealNative;
import eu.id3.bioseal.UserAuthenticationMethod;
import java.io.Serializable;
import java.nio.charset.Charset;

public class UserAuthentication
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public UserAuthentication() throws BiosealException {
        long[] pHandle = new long[]{0L};
        int err = UserAuthentication.nInitialize(pHandle);
        if (err != 0) {
            throw new BiosealException(err);
        }
        this.handle = pHandle[0];
    }

    public UserAuthentication(long handle) throws BiosealException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            UserAuthentication.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public UserAuthenticationMethod getMethod() throws BiosealException {
        int[] methodArray = new int[1];
        int err = UserAuthentication.nGetMethod(this.handle, methodArray);
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return UserAuthenticationMethod.fromValue(methodArray[0]);
    }

    public String getPasswordFieldName() throws BiosealException {
        byte[] passwordFieldName = null;
        int[] passwordFieldNameSizeArray = new int[]{-1};
        int err = UserAuthentication.nGetPasswordFieldName(this.handle, passwordFieldName, passwordFieldNameSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            passwordFieldName = new byte[passwordFieldNameSizeArray[0]];
            err = UserAuthentication.nGetPasswordFieldName(this.handle, passwordFieldName, passwordFieldNameSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(passwordFieldName, 0, passwordFieldNameSizeArray[0], Charset.defaultCharset());
    }

    public String getPasswordHashAlgorithm() throws BiosealException {
        byte[] passwordHashAlgorithm = null;
        int[] passwordHashAlgorithmSizeArray = new int[]{-1};
        int err = UserAuthentication.nGetPasswordHashAlgorithm(this.handle, passwordHashAlgorithm, passwordHashAlgorithmSizeArray);
        if (err == BiosealError.INSUFFICIENT_BUFFER.getValue()) {
            passwordHashAlgorithm = new byte[passwordHashAlgorithmSizeArray[0]];
            err = UserAuthentication.nGetPasswordHashAlgorithm(this.handle, passwordHashAlgorithm, passwordHashAlgorithmSizeArray);
        }
        if (err != BiosealError.SUCCESS.getValue()) {
            throw new BiosealException(err);
        }
        return new String(passwordHashAlgorithm, 0, passwordHashAlgorithmSizeArray[0], Charset.defaultCharset());
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetMethod(long var0, int[] var2);

    static native int nGetPasswordFieldName(long var0, byte[] var2, int[] var3);

    static native int nGetPasswordHashAlgorithm(long var0, byte[] var2, int[] var3);

    static {
        BiosealNative.loadLibraries();
    }
}

