//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealBiometricVerificationRule_h
#define _id3BiosealBiometricVerificationRule_h

#include <id3Bioseal/id3BiosealExports.h>
#include <id3Bioseal/id3BiosealBiometricDataType.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents a biometric verification rule.
 */

/**
 * Handle to a BiometricVerificationRule object of the Bioseal module.
 */
typedef struct id3BiosealBiometricVerificationRule *ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULE;

/**
 * @brief Initializes a BiometricVerificationRule object.
 * @param phBiometricVerificationRule [in] Handle to the BiometricVerificationRule object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealBiometricVerificationRule_Initialize(ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULE *phBiometricVerificationRule);

/**
 * @brief Releases the memory allocated for a BiometricVerificationRule.
 * @param phBiometricVerificationRule [in] Handle to the BiometricVerificationRule object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealBiometricVerificationRule_Dispose(ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULE *phBiometricVerificationRule);

/**
 * @brief Checks if the handle object is valid.
 * @param hBiometricVerificationRule [in] Handle to the BiometricVerificationRule object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealBiometricVerificationRule_CheckHandle(ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULE hBiometricVerificationRule);

/**
 * Gets the the type of biometric data to be used for verification.
 * @param hBiometricVerificationRule [in] Handle to the BiometricVerificationRule object.
 * @param eDataType [out] The type of biometric data to be used for verification.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealBiometricVerificationRule_GetDataType(ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULE hBiometricVerificationRule, id3BiosealBiometricDataType *eDataType);

/**
 * Gets the the number of biometric samples of the specified type to be verified.
 * @param hBiometricVerificationRule [in] Handle to the BiometricVerificationRule object.
 * @param count [out] The number of biometric samples of the specified type to be verified.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealBiometricVerificationRule_GetCount(ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULE hBiometricVerificationRule, int *count);

/**
 * Gets the the biometric decision threshold.
 * @param hBiometricVerificationRule [in] Handle to the BiometricVerificationRule object.
 * @param threshold [out] The biometric decision threshold.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealBiometricVerificationRule_GetThreshold(ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULE hBiometricVerificationRule, int *threshold);

#ifdef __cplusplus
}
#endif

#endif
