//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealDateTimeArray_h
#define _id3BiosealDateTimeArray_h

#include <id3Bioseal/id3BiosealExports.h>
#include <id3Bioseal/id3BiosealDateTime.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents an array of DateTime objects.
 */

/**
 * Handle to a DateTimeArray object of the Bioseal module.
 */
typedef struct id3BiosealDateTimeArray *ID3_BIOSEAL_DATE_TIME_ARRAY;

/**
 * @brief Initializes a DateTimeArray object.
 * @param phDateTimeArray [in] Handle to the DateTimeArray object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealDateTimeArray_Initialize(ID3_BIOSEAL_DATE_TIME_ARRAY *phDateTimeArray);

/**
 * @brief Releases the memory allocated for a DateTimeArray.
 * @param phDateTimeArray [in] Handle to the DateTimeArray object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealDateTimeArray_Dispose(ID3_BIOSEAL_DATE_TIME_ARRAY *phDateTimeArray);

/**
 * @brief Checks if the handle object is valid.
 * @param hDateTimeArray [in] Handle to the DateTimeArray object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealDateTimeArray_CheckHandle(ID3_BIOSEAL_DATE_TIME_ARRAY hDateTimeArray);

/**
 * Gets an item of the DateTimeArray object.
 * @param hDateTimeArray [in] Handle to the DateTimeArray object.
 * @param index [in] Index of the DateTime item to get.
 * @param hDateTimeItem [out] DateTime item to get.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealDateTimeArray_Get(ID3_BIOSEAL_DATE_TIME_ARRAY hDateTimeArray, int index, ID3_BIOSEAL_DATE_TIME hDateTimeItem);

/**
 * Gets the number of elements in the DateTimeArray object.
 * @param hDateTimeArray [in] Handle to the DateTimeArray object.
 * @param count [out] Number of elements in the DateTime object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealDateTimeArray_GetCount(ID3_BIOSEAL_DATE_TIME_ARRAY hDateTimeArray, int *count);

#ifdef __cplusplus
}
#endif

#endif
