//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealDecryptionCallbackHandler_h
#define _id3BiosealDecryptionCallbackHandler_h

#include <id3Bioseal/id3BiosealDecryptionArgs.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents the method that will handle a decryption callback.
 * @param context [in] The callback context.
 * @param hArgs [in] The decryption callback arguments. See DecryptionArgs for details.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
typedef int (* id3BiosealDecryptionCallbackHandler)(void *context, ID3_BIOSEAL_DECRYPTION_ARGS hArgs);

#ifdef __cplusplus
}
#endif

#endif
