//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealFieldType_h
#define _id3BiosealFieldType_h

#include <id3Bioseal/id3BiosealExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the field types present in the payload.
 */
typedef enum id3BiosealFieldType {
	/**
	 * Unknown type.
	 */
	id3BiosealFieldType_Unknown = 0,
	/**
	 * Integer.
	 */
	id3BiosealFieldType_Integer = 1,
	/**
	 * Boolean.
	 */
	id3BiosealFieldType_Boolean = 2,
	/**
	 * Float.
	 */
	id3BiosealFieldType_Float = 3,
	/**
	 * String.
	 */
	id3BiosealFieldType_String = 4,
	/**
	 * Binary.
	 */
	id3BiosealFieldType_Binary = 5,
	/**
	 * Date.
	 */
	id3BiosealFieldType_Date = 6,
	/**
	 * Value representing the number of seconds since 1970-01-01 00:00:00 UTC.
	 */
	id3BiosealFieldType_Timestamp = 7,
	/**
	 * Time.
	 */
	id3BiosealFieldType_Time = 8,
	/**
	 * Object.
	 */
	id3BiosealFieldType_Object = 9,
	/**
	 * Integer array.
	 */
	id3BiosealFieldType_IntegerArray = 10,
	/**
	 * Boolean array.
	 */
	id3BiosealFieldType_BooleanArray = 11,
	/**
	 * Float array.
	 */
	id3BiosealFieldType_FloatArray = 12,
	/**
	 * String array.
	 */
	id3BiosealFieldType_StringArray = 13,
	/**
	 * Binary array.
	 */
	id3BiosealFieldType_BinaryArray = 14,
	/**
	 * Date array.
	 */
	id3BiosealFieldType_DateArray = 15,
	/**
	 * Date array.
	 */
	id3BiosealFieldType_TimestampArray = 16,
	/**
	 * Object array.
	 */
	id3BiosealFieldType_ObjectArray = 17,
} id3BiosealFieldType;

ID3BIOSEAL_C_API const char * ID3_CDECL id3Bioseal_GetFieldTypeString(int value);

#ifdef __cplusplus
}
#endif

#endif
