//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealFormat_h
#define _id3BiosealFormat_h

#include <id3Bioseal/id3BiosealExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the BioSeal formats.
 */
typedef enum id3BiosealFormat {
	/**
	 * Undefined version.
	 */
	id3BiosealFormat_Undefined = 0,
	/**
	 * VDS compliant with the AFNOR standard XP Z42-101.
	 */
	id3BiosealFormat_VdsAfnorXpZ42_101 = 1,
	/**
	 * BioSeal compliant with the AFNOR XP Z42-105 standard and Otentik code specifications.
	 */
	id3BiosealFormat_VdsAfnorXpZ42_105 = 2,
	/**
	 * BioSeal compliant with the ISO 22376:2023 specifications.
	 */
	id3BiosealFormat_VdsIso22376_2023 = 3,
	/**
	 * BioSeal compliant with the ISO 22376:2023 specifications prefixed by the instance's ISO 15459 Issuing Agency Code.
	 */
	id3BiosealFormat_VdsIso22376WithIso15459Prefix = 4,
	/**
	 * BioSeal compliant with the AFNOR XP Z42-105 standard prefixed by the instance's ISO 15459 Issuing Agency Code.
	 */
	id3BiosealFormat_VdsAfnorXpZ42105WithIso15459Prefix = 5,
} id3BiosealFormat;

ID3BIOSEAL_C_API const char * ID3_CDECL id3Bioseal_GetBiosealFormatString(int value);

#ifdef __cplusplus
}
#endif

#endif
