//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealLibrary_h
#define _id3BiosealLibrary_h

#include <id3Bioseal/id3BiosealExports.h>
#include <id3Bioseal/id3BiosealLibVersion.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Provides essential methods for initializing the SDK and accessing version information.
 */

/**
 * Retrieves the library version as a 'X.Y.Z' formatted string.
 * @param libraryVersion [out] A string that identifies the library version.
 * @param libraryVersionSize [in,out] Size of the 'libraryVersion' buffer. Receives the minimum required buffer size to hold the 'libraryVersion' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'libraryVersion' (excluding terminating NULL character).
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealLibrary_GetVersion(char *libraryVersion, int *libraryVersionSize);

/**
 * Retrieves the library version as a structure.
 * @param sVersion [out] The version.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealLibrary_GetVersionEx(id3BiosealLibVersion *sVersion);

#ifdef __cplusplus
}
#endif

#endif
