//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealResourceCallbackHandler_h
#define _id3BiosealResourceCallbackHandler_h

#include <id3Bioseal/id3BiosealResourceCallbackArgs.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents the method that will handle a resource callback.
 * @param context [in] The callback context.
 * @param hArgs [in] The resource callback arguments. See ResourceCallbackArgs for details.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
typedef int (* id3BiosealResourceCallbackHandler)(void *context, ID3_BIOSEAL_RESOURCE_CALLBACK_ARGS hArgs);

#ifdef __cplusplus
}
#endif

#endif
