//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealResourceType_h
#define _id3BiosealResourceType_h

#include <id3Bioseal/id3BiosealExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the resource type for resource callback args.
 */
typedef enum id3BiosealResourceType {
	/**
	 * The resource is a undefined.
	 */
	id3BiosealResourceType_Undefined = 0,
	/**
	 * The resource is a manifest.
	 */
	id3BiosealResourceType_Manifest = 1,
	/**
	 * The resource is a certificate.
	 */
	id3BiosealResourceType_Certificate = 2,
	/**
	 * The resource is a TSL.
	 */
	id3BiosealResourceType_Tsl = 3,
	/**
	 * The resource is a CRL.
	 */
	id3BiosealResourceType_Crl = 4,
	/**
	 * The resource is a LOTL.
	 */
	id3BiosealResourceType_Lotl = 5,
	/**
	 * The resource is a PKCS7 P7S file.
	 */
	id3BiosealResourceType_P7S = 6,
} id3BiosealResourceType;

ID3BIOSEAL_C_API const char * ID3_CDECL id3Bioseal_GetResourceTypeString(int value);

#ifdef __cplusplus
}
#endif

#endif
