//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealBiometricVerificationRules_h
#define _id3BiosealBiometricVerificationRules_h

#include <id3Bioseal/id3BiosealExports.h>
#include <id3Bioseal/id3BiosealBiometricVerificationRule.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents a list of biometric verification rules.
 */

/**
 * Handle to a BiometricVerificationRules object of the Bioseal module.
 */
typedef struct id3BiosealBiometricVerificationRules *ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULES;

/**
 * @brief Initializes a BiometricVerificationRules object.
 * @param phBiometricVerificationRules [in] Handle to the BiometricVerificationRules object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealBiometricVerificationRules_Initialize(ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULES *phBiometricVerificationRules);

/**
 * @brief Releases the memory allocated for a BiometricVerificationRules.
 * @param phBiometricVerificationRules [in] Handle to the BiometricVerificationRules object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealBiometricVerificationRules_Dispose(ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULES *phBiometricVerificationRules);

/**
 * @brief Checks if the handle object is valid.
 * @param hBiometricVerificationRules [in] Handle to the BiometricVerificationRules object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealBiometricVerificationRules_CheckHandle(ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULES hBiometricVerificationRules);

/**
 * Gets the indicates whether all verification rules must be respected.
 * @param hBiometricVerificationRules [in] Handle to the BiometricVerificationRules object.
 * @param verifyAll [out] Indicates whether all verification rules must be respected.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealBiometricVerificationRules_GetVerifyAll(ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULES hBiometricVerificationRules, bool *verifyAll);

/**
 * Gets an item of the BiometricVerificationRules object.
 * @param hBiometricVerificationRules [in] Handle to the BiometricVerificationRules object.
 * @param index [in] Index of the BiometricVerificationRule item to get.
 * @param hBiometricVerificationRuleItem [out] BiometricVerificationRule item to get.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealBiometricVerificationRules_Get(ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULES hBiometricVerificationRules, int index, ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULE hBiometricVerificationRuleItem);

/**
 * Gets the number of elements in the BiometricVerificationRules object.
 * @param hBiometricVerificationRules [in] Handle to the BiometricVerificationRules object.
 * @param count [out] Number of elements in the BiometricVerificationRule object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealBiometricVerificationRules_GetCount(ID3_BIOSEAL_BIOMETRIC_VERIFICATION_RULES hBiometricVerificationRules, int *count);

#ifdef __cplusplus
}
#endif

#endif
