//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealCertificateExtension_h
#define _id3BiosealCertificateExtension_h

#include <id3Bioseal/id3BiosealExports.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Information about a certificate extension.
 */

/**
 * Handle to a CertificateExtension object of the Bioseal module.
 */
typedef struct id3BiosealCertificateExtension *ID3_BIOSEAL_CERTIFICATE_EXTENSION;

/**
 * @brief Initializes a CertificateExtension object.
 * @param phCertificateExtension [in] Handle to the CertificateExtension object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealCertificateExtension_Initialize(ID3_BIOSEAL_CERTIFICATE_EXTENSION *phCertificateExtension);

/**
 * @brief Releases the memory allocated for a CertificateExtension.
 * @param phCertificateExtension [in] Handle to the CertificateExtension object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealCertificateExtension_Dispose(ID3_BIOSEAL_CERTIFICATE_EXTENSION *phCertificateExtension);

/**
 * @brief Checks if the handle object is valid.
 * @param hCertificateExtension [in] Handle to the CertificateExtension object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealCertificateExtension_CheckHandle(ID3_BIOSEAL_CERTIFICATE_EXTENSION hCertificateExtension);

/**
 * Gets the the OID of the certificate extension.
 * @param hCertificateExtension [in] Handle to the CertificateExtension object.
 * @param oid [out] The OID of the certificate extension.
 * @param oidSize [in,out] Size of the 'oid' buffer. Receives the minimum required buffer size to hold the 'oid' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'oid' (excluding terminating NULL character).
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealCertificateExtension_GetOid(ID3_BIOSEAL_CERTIFICATE_EXTENSION hCertificateExtension, char *oid, int *oidSize);

/**
 * Gets the A byte array that contains the value of the certificate extension.
 * @param hCertificateExtension [in] Handle to the CertificateExtension object.
 * @param value [out] A byte array that contains the value of the certificate extension.
 * @param valueSize [in,out] Size of the 'value' buffer. Receives the number of elements in the 'value' array.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealCertificateExtension_GetValue(ID3_BIOSEAL_CERTIFICATE_EXTENSION hCertificateExtension, unsigned char *value, int *valueSize);

/**
 * Gets the A value indicating whether the certificate extension is critical.
 * @param hCertificateExtension [in] Handle to the CertificateExtension object.
 * @param critical [out] A value indicating whether the certificate extension is critical.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealCertificateExtension_GetCritical(ID3_BIOSEAL_CERTIFICATE_EXTENSION hCertificateExtension, bool *critical);

#ifdef __cplusplus
}
#endif

#endif
