//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealCertificateExtensionList_h
#define _id3BiosealCertificateExtensionList_h

#include <id3Bioseal/id3BiosealExports.h>
#include <id3Bioseal/id3BiosealCertificateExtension.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents a list of certificate extensions.
 */

/**
 * Handle to a CertificateExtensionList object of the Bioseal module.
 */
typedef struct id3BiosealCertificateExtensionList *ID3_BIOSEAL_CERTIFICATE_EXTENSION_LIST;

/**
 * @brief Initializes a CertificateExtensionList object.
 * @param phCertificateExtensionList [in] Handle to the CertificateExtensionList object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealCertificateExtensionList_Initialize(ID3_BIOSEAL_CERTIFICATE_EXTENSION_LIST *phCertificateExtensionList);

/**
 * @brief Releases the memory allocated for a CertificateExtensionList.
 * @param phCertificateExtensionList [in] Handle to the CertificateExtensionList object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealCertificateExtensionList_Dispose(ID3_BIOSEAL_CERTIFICATE_EXTENSION_LIST *phCertificateExtensionList);

/**
 * @brief Checks if the handle object is valid.
 * @param hCertificateExtensionList [in] Handle to the CertificateExtensionList object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealCertificateExtensionList_CheckHandle(ID3_BIOSEAL_CERTIFICATE_EXTENSION_LIST hCertificateExtensionList);

/**
 * Gets an item of the CertificateExtensionList object.
 * @param hCertificateExtensionList [in] Handle to the CertificateExtensionList object.
 * @param index [in] Index of the CertificateExtension item to get.
 * @param hCertificateExtensionItem [out] CertificateExtension item to get.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealCertificateExtensionList_Get(ID3_BIOSEAL_CERTIFICATE_EXTENSION_LIST hCertificateExtensionList, int index, ID3_BIOSEAL_CERTIFICATE_EXTENSION hCertificateExtensionItem);

/**
 * Gets the number of elements in the CertificateExtensionList object.
 * @param hCertificateExtensionList [in] Handle to the CertificateExtensionList object.
 * @param count [out] Number of elements in the CertificateExtension object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealCertificateExtensionList_GetCount(ID3_BIOSEAL_CERTIFICATE_EXTENSION_LIST hCertificateExtensionList, int *count);

#ifdef __cplusplus
}
#endif

#endif
