//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealFieldExtensionType_h
#define _id3BiosealFieldExtensionType_h

#include <id3Bioseal/id3BiosealExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the field extension types.
 */
typedef enum id3BiosealFieldExtensionType {
	/**
	 * No information given.
	 */
	id3BiosealFieldExtensionType_None = 0,
	/**
	 * No information given.
	 */
	id3BiosealFieldExtensionType_Unknown = 1,
	/**
	 * The Image extension specifies the expected type and format of the image data.
	 */
	id3BiosealFieldExtensionType_Image = 2,
	/**
	 * The Portrait extension specifies the guidelines to create the portrait image.
	 */
	id3BiosealFieldExtensionType_Portrait = 3,
	/**
	 * The Biometric extension specifies the expected type and format of the biometric data in the payload.
	 */
	id3BiosealFieldExtensionType_Biometric = 4,
	/**
	 * The Compression extension specifies the compression parameters.
	 */
	id3BiosealFieldExtensionType_Compression = 5,
	/**
	 * The Encryption extension is used to maintain the confidentiality of specific data in the payload.
	 */
	id3BiosealFieldExtensionType_Encryption = 6,
} id3BiosealFieldExtensionType;

ID3BIOSEAL_C_API const char * ID3_CDECL id3Bioseal_GetFieldExtensionTypeString(int value);

#ifdef __cplusplus
}
#endif

#endif
