//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealFieldList_h
#define _id3BiosealFieldList_h

#include <id3Bioseal/id3BiosealExports.h>
#include <id3Bioseal/id3BiosealField.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents a list of Field objects.
 */

/**
 * Handle to a FieldList object of the Bioseal module.
 */
typedef struct id3BiosealFieldList *ID3_BIOSEAL_FIELD_LIST;

/**
 * @brief Initializes a FieldList object.
 * @param phFieldList [in] Handle to the FieldList object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealFieldList_Initialize(ID3_BIOSEAL_FIELD_LIST *phFieldList);

/**
 * @brief Releases the memory allocated for a FieldList.
 * @param phFieldList [in] Handle to the FieldList object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealFieldList_Dispose(ID3_BIOSEAL_FIELD_LIST *phFieldList);

/**
 * @brief Checks if the handle object is valid.
 * @param hFieldList [in] Handle to the FieldList object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealFieldList_CheckHandle(ID3_BIOSEAL_FIELD_LIST hFieldList);

/**
 * Gets an item of the FieldList object.
 * @param hFieldList [in] Handle to the FieldList object.
 * @param index [in] Index of the Field item to get.
 * @param hFieldItem [out] Field item to get.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealFieldList_Get(ID3_BIOSEAL_FIELD_LIST hFieldList, int index, ID3_BIOSEAL_FIELD hFieldItem);

/**
 * Gets the number of elements in the FieldList object.
 * @param hFieldList [in] Handle to the FieldList object.
 * @param count [out] Number of elements in the Field object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealFieldList_GetCount(ID3_BIOSEAL_FIELD_LIST hFieldList, int *count);

/**
 * Clear the list.
 * @param hFieldList [in] Handle to the FieldList object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealFieldList_Clear(ID3_BIOSEAL_FIELD_LIST hFieldList);

#ifdef __cplusplus
}
#endif

#endif
