//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealLicenseError_h
#define _id3BiosealLicenseError_h

#include <id3Bioseal/id3BiosealExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the error codes related to license management.
 */
typedef enum id3BiosealLicenseError {
	/**
	 * No error.
	 */
	id3BiosealLicenseError_Success = 0,
	/**
	 * The given buffer is too small.
	 */
	id3BiosealLicenseError_InsufficientBuffer = -1,
	/**
	 * The requested object does not exist; a 'null' should be returned if possible.
	 */
	id3BiosealLicenseError_ObjectDoesNotExist = -2,
	/**
	 * Base error code of the License module.
	 */
	id3BiosealLicenseError_Base = -100,
	/**
	 * Minimum error code of the License module.
	 */
	id3BiosealLicenseError_Minimum = -999,
	/**
	 * The handle is invalid.
	 */
	id3BiosealLicenseError_InvalidHandle = -101,
	/**
	 * One of the parameters is incorrect.
	 */
	id3BiosealLicenseError_InvalidParameter = -102,
	/**
	 * No license was found.
	 */
	id3BiosealLicenseError_LicenseNotFound = -103,
	/**
	 * License is not valid or a required module is not licensed.
	 */
	id3BiosealLicenseError_InvalidLicense = -104,
	/**
	 * The license has expired.
	 */
	id3BiosealLicenseError_ExpiredLicense = -105,
	/**
	 * Installation code does not match hardware ID.
	 */
	id3BiosealLicenseError_InvalidHardwareId = -106,
	/**
	 * The license is already fulfilled by another user (or computer).
	 */
	id3BiosealLicenseError_AlreadyFulfilled = -107,
	/**
	 * A required module is not licensed or the usage limit has been reached.
	 */
	id3BiosealLicenseError_ModuleError = -108,
	/**
	 * The license file cannot be accessed in write mode.
	 */
	id3BiosealLicenseError_WriteError = -109,
	/**
	 * The number of available licenses has been reached. There isn't any available license remaining.
	 */
	id3BiosealLicenseError_InsufficientLicenseCredits = -110,
	/**
	 * The serial is invalid.
	 */
	id3BiosealLicenseError_InvalidSerial = -111,
	/**
	 * Invalid login or password.
	 */
	id3BiosealLicenseError_InvalidCredentials = -112,
	/**
	 * The license is revoked or does not exist anymore.
	 */
	id3BiosealLicenseError_RevokedLicense = -113,
	/**
	 * The license is blocked after a predefined period.
	 */
	id3BiosealLicenseError_BlockedLicense = -114,
	/**
	 * The license server is currently unreachable.
	 */
	id3BiosealLicenseError_UnreachableServer = -115,
	/**
	 * An unexpected error happened.
	 */
	id3BiosealLicenseError_LicenseOtherError = -116,
	/**
	 * No license file was provided.
	 */
	id3BiosealLicenseError_MissingFile = -117,
	/**
	 * This device is not compatible with id3 licensing system.
	 */
	id3BiosealLicenseError_DeviceNotCompatible = -118,
	/**
	 * The activation of the license has failed.
	 */
	id3BiosealLicenseError_ActivationFailed = -119,
	/**
	 * The license web services are unavailable.
	 */
	id3BiosealLicenseError_ServiceUnavailable = -120,
	/**
	 * The license is not renewable.
	 */
	id3BiosealLicenseError_NotRenewable = -121,
	/**
	 * The digest is invalid. The received file may be corrupted.
	 */
	id3BiosealLicenseError_DigestInvalid = -122,
	/**
	 * No credit available for this product.
	 */
	id3BiosealLicenseError_ProductUnavailable = -123,
	/**
	 * You are not allowed to do this.
	 */
	id3BiosealLicenseError_UnauthorizedAction = -124,
	/**
	 * The license will be shortly blocked.
	 */
	id3BiosealLicenseError_PreBlockedLicense = -125,
} id3BiosealLicenseError;

ID3BIOSEAL_C_API const char * ID3_CDECL id3Bioseal_GetLicenseErrorString(int value);
ID3BIOSEAL_C_API const char * ID3_CDECL id3Bioseal_GetLicenseErrorMessage(int value);

#ifdef __cplusplus
}
#endif

#endif
