//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealLicenseHardwareCodeType_h
#define _id3BiosealLicenseHardwareCodeType_h

#include <id3Bioseal/id3BiosealExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the types of hardware codes.
 */
typedef enum id3BiosealLicenseHardwareCodeType {
	/**
	 * License locked on Windows OS.
	 */
	id3BiosealLicenseHardwareCodeType_WindowsOs = 1,
	/**
	 * License locked on Linux OS.
	 */
	id3BiosealLicenseHardwareCodeType_LinuxOs = 3,
	/**
	 * License locked on Android device.
	 */
	id3BiosealLicenseHardwareCodeType_Android = 5,
	/**
	 * License locked on Android application package name.
	 */
	id3BiosealLicenseHardwareCodeType_AndroidPackageName = 6,
	/**
	 * License locked on iOS device.
	 */
	id3BiosealLicenseHardwareCodeType_Ios = 7,
	/**
	 * License locked on macOS.
	 */
	id3BiosealLicenseHardwareCodeType_MacOs = 8,
	/**
	 * License locked on Jetson Nano.
	 */
	id3BiosealLicenseHardwareCodeType_JetsonNano = 9,
	/**
	 * License locked on iOS application Bundle ID.
	 */
	id3BiosealLicenseHardwareCodeType_IosBundleId = 10,
	/**
	 * License locked on Windows USB stick.
	 */
	id3BiosealLicenseHardwareCodeType_WindowsUsb = 11,
	/**
	 * License locked on a smart card.
	 */
	id3BiosealLicenseHardwareCodeType_SmartCard = 12,
	/**
	 * License locked on a application.
	 */
	id3BiosealLicenseHardwareCodeType_Application = 13,
} id3BiosealLicenseHardwareCodeType;

ID3BIOSEAL_C_API const char * ID3_CDECL id3Bioseal_GetLicenseHardwareCodeTypeString(int value);

#ifdef __cplusplus
}
#endif

#endif
