//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealLicenseType_h
#define _id3BiosealLicenseType_h

#include <id3Bioseal/id3BiosealExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the license types.
 */
typedef enum id3BiosealLicenseType {
	/**
	 * Classic id3 license.
	 */
	id3BiosealLicenseType_Classic = 1,
	/**
	 * Trial id3 license with a time limitation.
	 */
	id3BiosealLicenseType_Trial = 2,
	/**
	 * Online id3 license with an online check.
	 */
	id3BiosealLicenseType_Online = 3,
} id3BiosealLicenseType;

ID3BIOSEAL_C_API const char * ID3_CDECL id3Bioseal_GetLicenseTypeString(int value);

#ifdef __cplusplus
}
#endif

#endif
