//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealStringArray_h
#define _id3BiosealStringArray_h

#include <id3Bioseal/id3BiosealExports.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents an array of strings.
 */

/**
 * Handle to a StringArray object of the Bioseal module.
 */
typedef struct id3BiosealStringArray *ID3_BIOSEAL_STRING_ARRAY;

/**
 * @brief Initializes a StringArray object.
 * @param phStringArray [in] Handle to the StringArray object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealStringArray_Initialize(ID3_BIOSEAL_STRING_ARRAY *phStringArray);

/**
 * @brief Releases the memory allocated for a StringArray.
 * @param phStringArray [in] Handle to the StringArray object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealStringArray_Dispose(ID3_BIOSEAL_STRING_ARRAY *phStringArray);

/**
 * @brief Checks if the handle object is valid.
 * @param hStringArray [in] Handle to the StringArray object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealStringArray_CheckHandle(ID3_BIOSEAL_STRING_ARRAY hStringArray);

/**
 * Gets an item of the StringArray object.
 * @param hStringArray [in] Handle to the StringArray object.
 * @param index [in] Index of the  item to get.
 * @param item [out]  item to get.
 * @param itemSize [in,out] Size of the 'item' buffer. Receives the minimum required buffer size to hold the 'item' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'item' (excluding terminating NULL character).
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealStringArray_Get(ID3_BIOSEAL_STRING_ARRAY hStringArray, int index, char *item, int *itemSize);

/**
 * Gets the number of elements in the StringArray object.
 * @param hStringArray [in] Handle to the StringArray object.
 * @param count [out] Number of elements in the  object.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealStringArray_GetCount(ID3_BIOSEAL_STRING_ARRAY hStringArray, int *count);

/**
 * Returns a value indicating whether a specified string occurs in this string array.
 * @param hStringArray [in] Handle to the StringArray object.
 * @param item [in] The string to seek.
 * @param result [out] true if the item parameter occurs within this string array; otherwise, false.
 * @return An error code. See id3BiosealError file for the list of possible error codes.
 * @retval id3BiosealError_Success The function succeeded.
 */
ID3BIOSEAL_C_API int ID3_CDECL id3BiosealStringArray_Contains(ID3_BIOSEAL_STRING_ARRAY hStringArray, const char *item, bool *result);

#ifdef __cplusplus
}
#endif

#endif
