//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealUserAuthenticationMethod_h
#define _id3BiosealUserAuthenticationMethod_h

#include <id3Bioseal/id3BiosealExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the user authentication methods.
 */
typedef enum id3BiosealUserAuthenticationMethod {
	/**
	 * The method is undefined.
	 */
	id3BiosealUserAuthenticationMethod_Undefined = 0,
	/**
	 * A password must be entered to authenticate.
	 */
	id3BiosealUserAuthenticationMethod_Password = 1,
	/**
	 * The user must present a biometric trait to authenticate.
	 */
	id3BiosealUserAuthenticationMethod_Biometrics = 2,
} id3BiosealUserAuthenticationMethod;

ID3BIOSEAL_C_API const char * ID3_CDECL id3Bioseal_GetUserAuthenticationMethodString(int value);

#ifdef __cplusplus
}
#endif

#endif
