# id3 BioSeal SDK Changelog

## Version 1.52.0 (2025-11-04)
- Added support for CEV with '#'.
- Added patch for Nume CEV manifest 000004 rev 3.
- Added C++ wrapper.

## Version 1.51.4 (2025-10-21)
- Fixed wrong real string size in getVersion.
- Fixed support for array other than object array.

## Version 1.51.3 (2025-10-15)
- [2d-doc] Fix ID 4Y (string).
- Fixed language resolution in presentation view process.
- Added log messages when a license module is not found.

## Version 1.51.2 (2025-08-19)
- [2d-doc] Added support for 2d-doc version 3.3.5
- [2d-doc] Added signature date is correct according certificat dates.
- Added CRL next update patch if year is 9999.
- [Android] Updated compile sdk to Version 36 (Android 16).
- [Android] Added support for 16 KB page sizes.

## Version 1.51.1 (2025-06-13)
- Added manifest parse in manifest load for manifest module.

## Version 1.50.0 (2025-06-02)
- Completely revamped documentation with comprehensive guides, API references, and usage examples.
- Added full license support.
- Correction of a crash when a certificate is supplied in PEM format.
- Added verification of duplicate fields in the manifest.
- Corrected generation of presentation views in German.

## Version 1.41.3 (2025-05-15)
- Added presentation view patch "@@data@@" and '@@data@@'.

## Version 1.41.2 (2025-05-12)
- Fixed 'subjectDN' and 'IssuerDN' pres view json injection to support UTF-8.
- Update XZing to 2.3.0

## Version 1.41.1 (2024-10-21)
- Fixed issue with empty TLS url.

## Version 1.41.0 (2024-10-18)
- Renamed Lotl.getTslUri() to getUri().
- Added Lotl.isTsl property.
- Fixed an issue in 64-bytes signature patch.
- Fixed an issue in LoTL/Tsl xml signature validation.

## Version 1.40.0 (2024-10-17)
- Added support for root LoTL.
- Added a fix for FR99 certificate and CRL issue. 

## Version 1.39.0 (2024-10-11)
- Added a patch to fix the 63-byte signature issue.

## Version 1.38.0 (2024-10-08)
- Added support for manifest tag `uuid` and `oid` in Authorized Usage Extension.

## Version 1.37.0 (2024-09-25)
- Added new date format (AAAAMMJJ) for 2d-doc field.
- Rename Bioseal.isIso15459Prefix to Bioseal.hasPrefix.
- Rename Bioseal.Cev to Bioseal.Data.

## Version 1.36.0 (2024-08-09)
- Added BarcodeReader class.
- Renamed BioSeal property DocumentSignatureDate to SignatureDate.
- Renamed BioSeal property CertificateAuthorityIssuingCountry to CertificateAuthorityReference.
- Renamed BioSeal property CertificateAuthorityId to CertificateIdentifier.
- Renamed BioSeal property VdsExpirationDate to ExpirationDate.

## Version 1.35.1 (2024-07-30)
- Added new BioSeal property : Cev.
- Added new argument for BioSeal CLI tool : '-q' to output cev.

## Version 1.35.0 (2024-07-30)
- Added verify from a QRcode, DataMatrix or Aztec picture.

## Version 1.34.1 (2024-07-29)
- Fixed base64 decod problem in CLI tool.

## Version 1.34.0 (2024-07-22)
- Added macOS python package.
- Added macOS dynamic library for Java.

## Version 1.33.0 (2024-07-02)
- Added BioSeal verification CLI tool id3BioSealVerifCLI.
- Renamed Bioseal.BuildPayloadAsJson() to BuildVdsAsJson().
- Added language parameter in Bioseal.BuildVdsAsXml().

## Version 1.32.0 (2024-07-02)
- Renamed BioSeal property VerifiesXmlSignature to VerifiesGovernance.
- Renamed BioSeal property IgnoresCrlUpdates to VerifiesCrlUpdates.
- Added BioSeal property VerifiesSignature.
- Added BioSeal property setter for TslUrl.
- Added BioSeal property setter for ManifestUrl.
- Removed BioSeal functions Decode(), DecodeFromString() and Verify().
- Added BioSeal function VerifyFromBuffer() (equivalent to Decode() + Verify()).
- Added BioSeal function VerifyFromString() (equivalent to DecodeFromString() + Verify()).
- Added function Manifest.LoadFromFile().
- Change ANTS 2d-doc LoTL URL to `https://pub.ants.gouv.fr/2D-DOC/V1/PRD/01_TSL/tsl_signed.xml`.

## Version 1.31.5 (2024-06-28)
- Fix containsExtensions if field is null.

## Version 1.31.4 (2024-06-28)
- Fixed an issue with BuildHtmlView().
- Fixed regular expression checking.

## Version 1.31.3 (2024-06-20)
- [java] Fix issue with wrong nGetBiosealErrorMessage function name.

## Version 1.31.1 (2024-06-19)
- Fixed an issue when decoding fails in an object.

## Version 1.31.0 (2024-06-18)
- Added support for 2d-doc TN list.
- Added support for LoTL IAC.
- Added support for PEM multi-certificat format.
- Update French 2d-doc to 3.3.4
- Added 'ARIADNEXT Root CA G3' url.
- Fix an issue with base45 decode.
- Implement ext:Label, ext:Abbreviation and ext:DictionariesExtension.
- Added functions Field.GetLocalizedLabel() and Field.GetLocalizedVvalue().

## Version 1.30.3 (2024-05-24)
- Add trimming of 2d-doc string.
- Add support for TN 2d-doc with FR format.
- Improved ANTS certificate decoding.

## Version 1.30.2 (2024-05-21)
- Fixed an issue in the title, in 2d-doc fr, in the presentation view.
- Fixed an issue when read the second certificat in FR05 crt.

## Version 1.30.1 (2024-05-17)
- Remove test code form 2d-doc 101 code.

## Version 1.30.0 (2024-05-15)
- Added Bioseal format ISO 22376 with ISO 15459 and AFNOR 105 with prefix.
- The property Bioseal.Format doesn't return prefix information, use Bioseal.ExtendedFormat instead.
- Removed BiosealStatus.VdsIso22376WithIso15459Prefix.
- Added Bioseal.IsIso15459Prefix and Prefix.
- Support for prefix 8 characters max.

## Version 1.29.0 (2024-04-22)
- Add support for Tunisian 2d-doc (101).
- Update French 2d-doc to 3.3.1

## Version 1.28.0 (2024-04-04)
- Restore compatibility with old manifest 'BiometricConstraints' for finger.

## Version 1.27.1 (2024-03-22)
- Rebuild with linux gcc 9.4

## Version 1.27.0 (2024-03-18)
- Add support for strange ANTS certificat file format.

## Version 1.26.6 (2024-03-04)
- Fixed incorrect string data returned by computeSha256().

## Version 1.26.5 (2024-02-28)
- Fixed crash when a manifest 'Description/Value' tag is empty.

## Version 1.26.4 (2024-02-21)
- Process default language in buildHtmlView().
- Added some information in presentation view data injection :
  - signature.signedOn
  - signature.validation
  - signature.certificate :
    - subjectCN
    - subjectDN
    - issuerCN
    - issuerDN
    - serialNumber
    - sigAlg
    - notBefore
    - notAfter
    - version

## Version 1.26.3 (2024-02-21)
- Check if the number of fields in the payload is equal to the number of fields in the manifest.

## Version 1.26.2 (2024-02-02)
- Update with codegen 3.29.1

## Version 1.26.1 (2024-02-01)
- Fixed compatibility issue with Biometric type.
- Added toString function in DateTime class.

## Version 1.26.0 (2024-01-16)
- Updated with Bioseal documentation revison 0.10
- Updated manifest Extension support.
- Updated manifest VisibilityCondition support.
- Replaced FindImages() and FindPortraits() by FindFieldsByExtension() and FindFieldsByExtensionName().
- Removed FindEncryptedFields().
- Added ExtensionList member in Manifest class.
- Replaced Field members BiometricDataType, BiometricFormat, IsImage, IsPortrait, IsEncrypted by ExtensionType and ManifestExtension.
- Updated BiometricDataType enumeration.
- Added ManifestExtension enumeration.
- Added Field member VisibilityCondition and VisibilityCondition enumeration.
- Added Field functions ContainsExtensions(), ContainsExtensionsByName() and CheckBiometric().
- Added class Extension and ExtensionList.
- Added Clear() function in FieldList.
- Added experimental CheckLicense() in BiosealLibrary (for test only).
- Experimental support for UTF-16 (for test only).
- Updated zlib to 1.3.
- Added support for license.
- Added Bioseal.BuildVdsAsXml().

## Version 1.25.3 (2024-01-05)
- Fixed issue with base45 decoding.

## Version 1.25.2 (2024-01-05)
- Fixed issue with base45 error code.

## Version 1.25.1 (2024-01-05)
- Added error code in base 45 decode.

## Version 1.25 (2023-11-28)
- Fixed some missing fields for 2d-doc (update 3.2.5/3.2.6).
- Fixed some log and 'vercel' patch.
- Fixed issues with manifest format.
- Update 2d-doc tables to 3.2.9.
- Update certificate infos whenever it's possible.
- Restore 'acroot-g4.crl' replacement (Certinomis Corporate G5 integrated).
- Fixed signature size computing.
- Replace MbedTLS with OpenSSL 3.

## Version 1.24.1 (2023-10-23)
- Fixed issue with 'From' date constraint when no constraints found.

## Version 1.24.0 (2023-10-16)
- Change python package name (lowercase).
- Added support for default and multi-language presentation view.

## Version 1.23.2 (2023-09-18)
- Certinomis Corporate G5 integrated
- Fixed CRL validation with wrong issuer

## Version 1.23.1 (2023-08-29)
- Fixed issue with python package.
- Update code with codegen 3.21.3.

## Version 1.23.0 (2023-08-24)
- Added support for base45 encoding format.

## Version 1.22.0 (2023-08-23)
- Update with ANTS 2d-doc 101 specification V3.2.7
- Fixed decoding issue when a prefix is present.
- Update with codegen 3.21.1.

## Version 1.21.0 (2023-08-21)
- Added support of ISO 22376:2023 decoding.
- Added Issuing Agency Code Bioseal property for ISO 22376:2023.
- Added support for ISO/IEC 15459-2 prefix.
- Added 2 formats: ISO 22376 and ISO 22376 with ISO 15459.

## Version 1.20.0 (2023-08-11)
- Update with codegen 3.19.0.
- Added support for python.

## Version 1.19.0 (2023-08-09)
- Added a presentation view for Tunisian 101 2ddoc and 105 without presentation view.

## Version 1.18.1 (2023-08-08)
- Remove log info and P7S check if EnableXmlSignatureVerification if false.

## Version 1.18.0 (2023-08-07)
- Added the ability to create a presentation view even if the verification process failed.
- Fixed issue when a certificate embedded in a TLS is formatted.
- Update with codegen 1.17.3 (but without new python wrapper now).

## Version 1.18.rc1 (2023-06-28)
- Update with codegen 1.16.0: Added support for java iterator.

## Version 1.17.0 (2023-06-27)
- Fixed issue with multi-threading xades verification.
- Added support for 'ext:Image' extension (new function FindImage).
- Added support for 'ext:Portrait' extension (new function FindPortrait).
- Added support for 'ext:Biometric' extension.
- API breaking change: 
    * Removed BiometricDataType.FaceImage, see FindPortrait(), ContainsPortraits() and IsPortrait().
    * Replaced BiometricDataType.FaceTemplate with FacialFeatures.
    * Replaced BiometricDataType.FingerTemplate with Fingerprint.
    * Removed BiometricFormat enumeration, replaced by a string.
- Improved download error log.
- Added support for cades xml verification.
- Added patch to support ANTS LoTL/TSL/Manifest chain.

## Version 1.16.2 (2023-04-25)
- Change ANTS 2d-doc url to https://trust.otentik.codes/2d-doc/TSL_ANTS_2DDOC.xml.

## Version 1.16.1 (2023-04-20)
- Restore same curl options as 1.15.
- Change otentik url to HTTPS.

## Version 1.16.0 (2023-04-19)
- Update curl download process.
- Update 2D-DOC spec with version 3.2.6.
- Update ANTS 2D-DOC TSL url.

## Version 1.15.1 (2023-04-17)
- Fixed issue with *CertificationChainVerified* flag update with 2d-doc.
- Update 2d-doc presentation vue.
- Added more log information when a download error is fired.

## Version 1.15.0 (2023-04-11)
- Removed Bioseal.CheckVdsValidityPeriod() function and Bioseal.EnableCheckingVdsValidityPeriod property.
- Fixed issue with Bioseal.VdsExpirationDate property when no *VDSValidityPeriod* manifest extension.
- Update presentation vue generation certificat information.

## Version 1.14.0 (2023-04-03)
- Added Manifets.load() and loadFromString().
- Added Manifets.getSupportedLanguages(), GetDocumentName() and GetDocumentDescription().
- Added Manifets.Log property is case of individual usage.
- Added ResourceCallbackArgs.DownloadStringFile() function.
- Fixed issue when language paramter is null.
- Change verification process behavior with CRL when CRL process have an error.

## Version 1.13.0 (2023-03-30)
- Don't use ... bad release. 

## Version 1.12.0 (2023-03-21)
- Limit download cache to a single bioseal process. 
- Remove sha256 process for Otentik XML files (Applications must handle this feature).
- Sync with codegen 3.10.0.
- Enabled 'nullable' functionnality for function thta return a date.
- Added module lotl with getTslUrl() and getManifestUrl() functions.

## Version 1.11.2 (2023-03-10)
- Fixed issue if CRL is not up to date (requested new CRL download).

## Version 1.11.1 (2023-03-01)
- Fixed issue (buildHtmlView error) with 2d-doc use for test.

## Version 1.11.0 (2023-02-27)
- Added LoTL, TSL and manifest url getter.
- Added LoTL setter.
- Fix issue with 2d-doc gouvernance.
- Added debug information in log and filter in Log.ExportToXX functions.
- Added VerificationResult.LotlGovernanceValid, TslGovernanceValid and ManifestGovernanceValid.
- Added verify Root CA (Certificat embedded in TSL);

## Version 1.10.1 (2023-02-20)
- Fixed issue with external resource callback.
- Added Bioseal.IgnoresCrlUpdates property (Skips checking for the next CRL update, default to false).

## Version 1.10.0 (2023-02-17)
- Internal download cache is enabled by default (use Bioseal.enableDownloadCache to disabled it).
- Added sha256 process for Otentik XML files (use Bioseal.enableSha256Process to disabled it).
- Added Bioseal.computeSha256 and ResourceCallbackArgs.computeSha256 functions.
- Added support for ResourceCallbackArgs.requiresUpdate property.
- Added support for ResourceCallbackArgs.requiresSha256 and ResourceCallbackArgs.shaUri property.

## Version 1.9.1 (2023-02-13)
- Release linux shared library with version (libid3Bioseal.so.x.y.z).
- Remove bioseal.getManifestVersion().
- Fixed issue with bioseal.getManifestId() that returned wrong id. Now returned bioseal id and version in ISO 22385 format.
- Added biosealLibrary.getVersionXyz() and biosealLibrary.clearDownloadCache() functions.

## Version 1.9.0 (2023-02-10)
- Implement ISO 22385 manfest id / version.
- Remove getManifestRevision.
- With XP Z42-105 format, getManifestId return manifest id and manifest verson in ISO 22385 format.
- With XP Z42-105 format, getManifestVersion return manifest revision.
- Fixed issue in buildHtmlView when no certificate information available.
- Added CertificateInformation.GetSerialNumberString function to return the certficate serial number as a pre-formaated string.
- Added support for default language in getDocumentName and getDocumentDescription.

## Version 1.8.2 (2023-02-08)
- Fixed issue with removing java_ symbols in so.
- Restore `strip` from linux CI.

## Version 1.8.1 (2023-02-08)
- Remove `strip` from linux CI.
- Added a mutex to protect XML signing verification process.
- Use OpenSSL 3.0.5 in iOS build.

## Version 1.8.0 (2023-02-06)
- Fixed issue with certificate issuer and subject C, O and OU.
- Fix 2d-2doc issue with verification result structure process.
- API change for class CertificateInformation:
  - IssuerCn becomes IssuerCommonName.
  - IssuerDn becomes IssuerDistinguishedName.
  - SubjectCn becomes SubjectCommonName.
  - SubjectDn becomes SubjectDistinguishedName.
- Added CertificateInformation functions:
  - GetIssuerOrganisation and GetSubjectOrganisation.
  - GetIssuerOrganisationUnit and GetSubjectOrganisationUnit.
  - GetIssuerCountry and GetSubjectCountry.
- Update to codegen 3.7.8.
- Update to dart ffi : 2.0.1.
- Fixed Apple build withc cache.
- Added a structure in verify() function with verification check list.

## Version 1.7.3 (2023-01-20)
- Fixed Apple build.

## Version 1.7.2 (2023-01-20)
- Fixed issue with fixed certificat information in presentation vue and json payload outputs.

## Version 1.7.1 (2023-01-16)
- Added enableXmlSignatureVerification property in Bioseal class to enable or disable the XML signature verification (multi-threaading issue).

## Version 1.7.0 (2023-01-16)
- Added support for encrypted field. Decryption need a callback, see Bioseal.DecryptionCallback.
- Remove bubug print to console form XML signature verification module.
- Added log in XML signature verification.
- Added new error code in the certificat verif process.
- Added Field.containsBiometrics and isEncrypted.
- Added support for *ext:UserAuthenticationExtension* manifest extension.

## Version 1.6.3 (2023-01-11)
- Fixed issue with 'Country = FRA' in presentation view.

## Version 1.6.2 (2023-01-04)
- Fixed bug with FFFF marker date in 101.
- Added 2d-doc and otentik header version in API.

## Version 1.6.1 (2022-12-13)
- Added EnableCheckingVdsValidityPeriod property (default true).
- Fixed crash with a TSL object without a log object.
- Added support for *VisibilityCondition.NotExpired* condition.

## Version 1.6.0 (2022-12-13)
- Added UserAuthentication class for ext:UserAuthentication manifest extension support.
- Added support for Otentik LOTL.
- Changing resource names for download.

## Version 1.5.1 (2022-12-13)
- Fixed issue of displaying the photo in the presentation view.

## Version 1.5.0 (2022-11-24)
- Added support for default language in buildHtmlView().
- Added support for space and ctrl char in base64 string.
- Added setTimeZoneOffset function to add time offset in seconds to payload timestamp.
- Added full support for timestamp fields.

## Version 1.4.4 (2022-11-17)
- Added support for boolean and float field in buildPayloadAsJson().

## Version 1.4.3 (2022-11-17)
- Fixed issus with wrong return code with CheckVdsValidityPeriod().

## Version 1.4.2 (2022-11-16)
- Fixed issus with remainder test code with CheckVdsValidityPeriod().

## Version 1.4.1 (2022-11-16)
- Added CheckVdsValidityPeriod() function and remove of corresponding test from Decode().

## Version 1.4.0 (2022-11-15)
- Added CertificateInformation.GetIssuerDn() and GetSubjectDn().
- Added CertificateExtension and CertificateExtensionList class.
- Added CertificateInformation.GetSerialNumber().
- Added CertificateInformation.GetData().
- Added CertificateInformation.GetSignatureAlgorithm().
- Added CertificateInformation.GetVersion().
- Added CertificateInformation.GetPublicKey() [not implemented].
- Added CertificateInformation.GetKeyUsage().
- Added CertificateInformation.GetPolicies().
- Added CertificateInformation.GetCertificateExtensionList().
- Fixed issue with boolean in a presentation view.

## Version 1.3.6 (2022-11-10)
- Update wrapper with codegen 3.7.2 (Fix java callback).
- Added BiosealErrorNoSignatureFound error code.

## Version 1.3.5 (2022-11-09)
- Fixed issue with utf-8 regex.

## Version 1.3.4 (2022-11-08)
- Fixed issue in verification process.

## Version 1.3.3 (2022-11-08)
- Fixed issue with regex and utf-8 (experimental).
- Fixed issue with Java JNI callback context.

## Version 1.3.2 (2022-11-04)
- Added support for old and new certficate uri for 'Notarius Certificate Authority'.

## Version 1.3.1 (2022-10-26)
- Fixed issue with dart and libcurl (error DownloadBadFunctionArgument): update to libcurl 7.85.0.
- Fixed a potential issue with utf-8 conversion in Android.

## Version 1.3.0 (2022-10-20)
- Fired error *SigningCertificateExpired* if the BioSeal was generated with an expired certificate.
- Integration of XML signature validation.
- Fixed issue in 2d-doc format whis endless variable field.
- Print document name instead of document id in 2d-doc presentation view.
- Fixed issue with certificate without CRL.

## Version 1.2.2 (2022-10-18)
- Fixed issue when a array is *Nillable* in a manifest.

## Version 1.2.1 (2022-10-18)
- Added support for utf-8 string in manifest constraints.

## Version 1.2.0 (2022-10-11)
 - Added validation of manifest constraints to decoding.
 - Added support for visibility conditions (visibilityCondition attribute in manifest).
 - Added userAuthenticated parameter in BuildHtmlView() function.
 - Added support for aux data.
 - Added ext::RevocationInfoValidityPeriod checking.
 - Fixed issue in certification chain verification process.
 - Added support for BiometricVerification.

## Version 1.1.1 (2022-09-28)
 - Fixed ext:AuthorizedUsage and ext:VDSValidityPeriod process.

## Version 1.1.0 (2022-09-28)
 - Added decode error codes.
 - Fixed float field in 101 presentation view (Issue #42). 
 - Change ResourceCallbackArgs.ForceDownload property to RequiresUpdate (Issue #38).
 - Added GetVdsExpirationDate() function (Issue #40).
 - Separate VerifySignature process from Decode() function (Issue #41): added Verify() function.
 - Update with codegen 3.7.0.
 - Remove support for id3License() (Issue #44).
 
## Version 1.0.0 (2022-09-08)
 - Completed unit tests with dart, java and dotnet.

## Version 1.0.0-rc.20 (2022-09-08)
 - Added BiosealLibrary.GetVersion and CheckModule.
 - Changed resource name (ResourceCallbackArgs): removed space in name and all certificates have .cer extension.
 - Fixed Java callback crash with some linux like Debian.
 - Added support for dart NativeFinalizer.
 
 ## Version 1.0.0-rc.19 (2022-09-06)
 - Fixed `\r\n` in a string injected in a presentation view. 
 - Added BiosealLibrary.CheckLicense() and BiosealLibrary.CheckLicenseBuffer() static functions.

 ## Version 1.0.0-rc.18 (2022-09-05)
 - Added Bioseal.BuildPayloadAsJson() function.

 ## Version 1.0.0-rc.17 (2022-09-01)
 - Removed download sslVerifyPeer option.
 - Added default timeout (30s) for download process.

 ## Version 1.0.0-rc.15 (2022-08-25)
 - Enabling 'BioSeal' license module verification.

 ## Version 1.0.0-rc.14 (2022-08-24)
 - Authorized Usage processing (ext:AuthorizedUsage).
 - VDS Validity Period processing (ext:VDSValidityPeriod).
 - Payload decoding even if signature validation fails.

 ## Version 1.0.0-rc.13 (2022-08-22)
 - Fixed issue in ContainsXXX properties when bioseal is not in Otentik format.

 ## Version 1.0.0-rc12 (2022-08-19)
 - Removed ResourceCallbackArgs.OutputData (string version).
 - Change ResourceCallbackArgs.OutputDataBin name by ResourceCallbackArgs.OutputData (keep only binary version).
 - Added resource download function.

 ## Version 1.0.0-rc11 (2022-08-18)
 - Updated with id3License 8.4.4.
 - Added mbedtls 3.2.1 CRL parser with crital extension fix.
 - Added Field.isNull() function.
 - Restored CRL checking process in 105.
 - Restored license support in Apple build.
 - Added Bioseal.GetCertificateAuthorityIssuingCountry().
 - Added Bioseal.GetCertificateAuthorityId().
 - Added certificate information (Bioseal.CertificateInformation).

 ## Version 1.0.0-rc10 (2022-08-10)
 - Added Notarius Certificate URI.
 - Fix 'ContainsBiometrics' issue.
 - Update wrapper with codegen 3.3.0 (Java callback).

 ## Version 1.0.0-rc9 (2022-08-08)
 - Disabling CRL checking process in 105.
 - Finalization of the verification process in 2d-doc.
 - Update Bioseal and Field API.
 - Change CodeVersion enum to BiosealFormat.
 - Change callback name to 'ExternalResourceCallback'.
 - Added property ResourceCallbackArgs.OutputDataBin.
 - Added property ResourceCallbackArgs.ResourceName.
 - Added property ResourceCallbackArgs.ResourceType.
 - Removed certification information element from common.utils.js and the presentation view.

 ## Version 1.0.0-rc8 (2022-07-25)
 - Fixed issue when a presentation view does'nt have data.
 - Fixed issue when no callback defined.
 - Enabled iOS / MACOS build.
 - Fixed array of bool in dart.
 - Complete d2-doc unit tests.
 - Added properties Bioseal.FaceImage and Bioseal.FaceTemplate.
 
 ## Version 1.0.0-rc7 (2022-07-21)
 - Added insertion of the 'face_image' in the presentation view.
 
 ## Version 1.0.0-rc6 (2022-07-21)
 - Added function Bioseal.GetManifestId()
 - Added function Bioseal.GetManifestVersion()
 - Added function Bioseal.GetManifestRevision()
 - Added function Bioseal.ContainsFaceImage()
 - Added function Bioseal.ContainsFaceTemplate()
 - Added function StringArray.Contains().
 - Fixed issue with 2d-doc presentation view.

 ## Version 1.0.0-rc5 (2022-07-20)
 - Fixed issue with dates in 105 format.

 ## Version 1.0.0-rc4 (2022-07-19)
 - Change Otentik manifest uri to enabled test.

 ## Version 1.0.0-rc3 (2022-07-19)
 - Added Otentik format (local test only).
 
 ## Version 1.0.0-rc2 (2022-07-19)
 - Fixed some issues with 2d-doc.
 
 ## Version 1.0.0-rc1 (2022-07-11)
 - Initial release with 2d-doc format.
