library id3_bioseal;

// %export-begin%
export 'src/date_time.dart';
export 'src/bioseal.dart';
export 'src/lotl.dart';
export 'src/manifest.dart';
export 'src/field.dart';
export 'src/extension.dart';
export 'src/extension_list.dart';
export 'src/string_array.dart';
export 'src/decryption_args.dart';
export 'src/date_time_array.dart';
export 'src/field_list.dart';
export 'src/bioseal_library.dart';
export 'src/certificate_extension.dart';
export 'src/certificate_extension_list.dart';
export 'src/certificate_information.dart';
export 'src/biometric_verification_rule.dart';
export 'src/biometric_verification_rules.dart';
export 'src/user_authentication.dart';
export 'src/log_item.dart';
export 'src/log.dart';
export 'src/resource_callback_args.dart';
export 'src/bioseal_error.dart';
export 'src/bioseal_format.dart';
export 'src/field_type.dart';
export 'src/resource_type.dart';
export 'src/biometric_data_type.dart';
export 'src/log_item_type.dart';
export 'src/user_authentication_method.dart';
export 'src/visibility_condition.dart';
export 'src/field_extension_type.dart';
export 'src/bioseal_exception.dart';
export 'src/verification_result.dart';
export 'src/decryption_callback_handler.dart';
export 'src/resource_callback_handler.dart';
export 'src/lib_version.dart';
export 'src/barcode_reader.dart';
export 'src/license_hardware_code_type.dart';
export 'src/license_type.dart';
export 'src/license_error.dart';
export 'src/bioseal_license.dart';
// %export-end%

import 'dart:ffi';
import 'dart:math';
import 'dart:typed_data';

extension ArrayIntFill<T> on Array<Int32> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as int;
    }
  }

  List<int> toList(int length) {
    final list = List<int>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return list;
  }
}

extension ArrayLongFill<T> on Array<Int64> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as int;
    }
  }

  List<int> toList(int length) {
    final list = List<int>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return list;
  }
}

extension ArrayInt8Fill<T> on Array<Int8> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as int;
    }
  }

  Int8List toList(int length) {
    final list = List<int>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return Int8List.fromList(list);
  }
}

extension ArrayUInt8Fill<T> on Array<Uint8> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as int;
    }
  }

  Uint8List toList(int length) {
    final list = List<int>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return Uint8List.fromList(list);
  }
}

extension ArrayFloat32Fill<T> on Array<Float> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as double;
    }
  }

  List<double> toList(int length) {
    final list = List<double>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return list;
  }
}
