//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates the supported biometric data types.
enum BiometricDataType {
	/// The biometric data type is a undefined.
	undefined,
	/// No information given.
	noInformationGiven,
	/// Multiple biometric data used.
	multipleBiometricsUsed,
	/// Facial features data.
	facialFeatures,
	/// Voice data.
	voice,
	/// Fingerprint data.
	fingerprint,
	/// Iris data.
	iris,
	/// Retina data.
	retina,
	/// Hand geometry.
	handGeometry,
	/// Signature dynamics.
	signatureDynamics,
	/// Keystroke dynamics.
	keystrokeDynamics,
	/// Lip movement.
	lipMovement,
	/// Thermal face image.
	thermalFaceImage,
	/// Thermal hand image.
	thermalHandImage,
	/// Gait.
	gait,
	/// Body odor.
	bodyOdor,
	/// DNA.
	dna,
	/// Ear shape.
	earShape,
	/// Finger geometry.
	fingerGeometry,
	/// Palmprint data.
	palmPrint,
	/// Vein pattern
	veinPattern,
	/// Footprint data.
	footPrint,
}

extension BiometricDataTypeX on BiometricDataType {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created BiometricDataType.
  	static BiometricDataType fromValue(int value) {
    	switch (value) {
      	case 0:
        	return BiometricDataType.undefined;
      	case 1:
        	return BiometricDataType.noInformationGiven;
      	case 2:
        	return BiometricDataType.multipleBiometricsUsed;
      	case 3:
        	return BiometricDataType.facialFeatures;
      	case 4:
        	return BiometricDataType.voice;
      	case 5:
        	return BiometricDataType.fingerprint;
      	case 6:
        	return BiometricDataType.iris;
      	case 7:
        	return BiometricDataType.retina;
      	case 8:
        	return BiometricDataType.handGeometry;
      	case 9:
        	return BiometricDataType.signatureDynamics;
      	case 10:
        	return BiometricDataType.keystrokeDynamics;
      	case 11:
        	return BiometricDataType.lipMovement;
      	case 12:
        	return BiometricDataType.thermalFaceImage;
      	case 13:
        	return BiometricDataType.thermalHandImage;
      	case 14:
        	return BiometricDataType.gait;
      	case 15:
        	return BiometricDataType.bodyOdor;
      	case 16:
        	return BiometricDataType.dna;
      	case 17:
        	return BiometricDataType.earShape;
      	case 18:
        	return BiometricDataType.fingerGeometry;
      	case 19:
        	return BiometricDataType.palmPrint;
      	case 20:
        	return BiometricDataType.veinPattern;
      	case 21:
        	return BiometricDataType.footPrint;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case BiometricDataType.undefined:
        	return 0;
      	case BiometricDataType.noInformationGiven:
        	return 1;
      	case BiometricDataType.multipleBiometricsUsed:
        	return 2;
      	case BiometricDataType.facialFeatures:
        	return 3;
      	case BiometricDataType.voice:
        	return 4;
      	case BiometricDataType.fingerprint:
        	return 5;
      	case BiometricDataType.iris:
        	return 6;
      	case BiometricDataType.retina:
        	return 7;
      	case BiometricDataType.handGeometry:
        	return 8;
      	case BiometricDataType.signatureDynamics:
        	return 9;
      	case BiometricDataType.keystrokeDynamics:
        	return 10;
      	case BiometricDataType.lipMovement:
        	return 11;
      	case BiometricDataType.thermalFaceImage:
        	return 12;
      	case BiometricDataType.thermalHandImage:
        	return 13;
      	case BiometricDataType.gait:
        	return 14;
      	case BiometricDataType.bodyOdor:
        	return 15;
      	case BiometricDataType.dna:
        	return 16;
      	case BiometricDataType.earShape:
        	return 17;
      	case BiometricDataType.fingerGeometry:
        	return 18;
      	case BiometricDataType.palmPrint:
        	return 19;
      	case BiometricDataType.veinPattern:
        	return 20;
      	case BiometricDataType.footPrint:
        	return 21;
		}
  	}
}
