//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'bioseal_sdk_generated_bindings.dart';
import 'bioseal_native.dart';

import '../id3_bioseal.dart';

final _finalizer = NativeFinalizer(biosealSDK.addresses.id3BiosealBiometricVerificationRule_Dispose.cast());

/// Represents a biometric verification rule.
class BiometricVerificationRule implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3BiosealBiometricVerificationRule>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3BiosealBiometricVerificationRule> get handle => _pHandle.value;

  /// Creates a new instance of the BiometricVerificationRule class.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  BiometricVerificationRule() {
    _pHandle = calloc();
    try {
      var err = biosealSDK.id3BiosealBiometricVerificationRule_Initialize(_pHandle);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the BiometricVerificationRule class.
  ///
  /// param handle     Handle to the BiometricVerificationRule.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  BiometricVerificationRule.fromHandle(Pointer<id3BiosealBiometricVerificationRule> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this BiometricVerificationRule.
  void dispose() {
    if (_disposable) {
      biosealSDK.id3BiosealBiometricVerificationRule_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }


  ///
  /// The type of biometric data to be used for verification.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  BiometricDataType get dataType => getDataType();

  ///
  /// The number of biometric samples of the specified type to be verified.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int get count => getCount();

  ///
  /// The biometric decision threshold.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int get threshold => getThreshold();

  // Public methods
  /// Gets the the type of biometric data to be used for verification.
  ///
  /// return The type of biometric data to be used for verification.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  BiometricDataType getDataType() {
    Pointer<Int32> pDataType = calloc();
    try {
      var err = biosealSDK.id3BiosealBiometricVerificationRule_GetDataType(_pHandle.value, pDataType);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vDataType = BiometricDataTypeX.fromValue(pDataType.value);
      return vDataType;
    } finally {
      calloc.free(pDataType);
    }
  }

  /// Gets the the number of biometric samples of the specified type to be verified.
  ///
  /// return The number of biometric samples of the specified type to be verified.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = biosealSDK.id3BiosealBiometricVerificationRule_GetCount(_pHandle.value, pCount);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

  /// Gets the the biometric decision threshold.
  ///
  /// return The biometric decision threshold.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int getThreshold() {
    Pointer<Int> pThreshold = calloc();
    try {
      var err = biosealSDK.id3BiosealBiometricVerificationRule_GetThreshold(_pHandle.value, pThreshold);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vThreshold = pThreshold.value;
      return vThreshold;
    } finally {
      calloc.free(pThreshold);
    }
  }

}

