//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:collection';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'bioseal_sdk_generated_bindings.dart';
import 'bioseal_native.dart';

import '../id3_bioseal.dart';

final _finalizer = NativeFinalizer(biosealSDK.addresses.id3BiosealBiometricVerificationRules_Dispose.cast());

/// Represents a list of biometric verification rules.
class BiometricVerificationRules extends Object with IterableMixin<BiometricVerificationRule> implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3BiosealBiometricVerificationRules>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3BiosealBiometricVerificationRules> get handle => _pHandle.value;

  /// Creates a new instance of the BiometricVerificationRules class.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  BiometricVerificationRules() {
    _pHandle = calloc();
    try {
      var err = biosealSDK.id3BiosealBiometricVerificationRules_Initialize(_pHandle);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the BiometricVerificationRules class.
  ///
  /// param handle     Handle to the BiometricVerificationRules.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  BiometricVerificationRules.fromHandle(Pointer<id3BiosealBiometricVerificationRules> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this BiometricVerificationRules.
  void dispose() {
    if (_disposable) {
      biosealSDK.id3BiosealBiometricVerificationRules_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  /// Gets or sets the element at the specified index.
  operator [](int key) => get(key);

  /// Gets the number of elements contained in the list or dictionary.
  int get count => getCount();

  @override
  Iterator<BiometricVerificationRule> get iterator => BiometricVerificationRulesIterator(this);

  ///
  /// Indicates whether all verification rules must be respected.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  bool get verifyAll => getVerifyAll();

  // Public methods
  /// Gets an item of the BiometricVerificationRules object.
  ///
  /// param index Index of the BiometricVerificationRule item to get.
  /// return BiometricVerificationRule item to get.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  BiometricVerificationRule get(int index) {
    BiometricVerificationRule biometricVerificationRuleItem = BiometricVerificationRule();
    var err = biosealSDK.id3BiosealBiometricVerificationRules_Get(_pHandle.value, index, biometricVerificationRuleItem.handle);
    if (err != BiosealError.success.value) {
      biometricVerificationRuleItem.dispose();
      throw BiosealException(err);
    }
    return biometricVerificationRuleItem;
  }

  /// Gets the number of elements in the BiometricVerificationRules object.
  ///
  /// return Number of elements in the BiometricVerificationRule object.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = biosealSDK.id3BiosealBiometricVerificationRules_GetCount(_pHandle.value, pCount);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

  /// Gets the indicates whether all verification rules must be respected.
  ///
  /// return Indicates whether all verification rules must be respected.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  bool getVerifyAll() {
    Pointer<Bool> pVerifyAll = calloc();
    try {
      var err = biosealSDK.id3BiosealBiometricVerificationRules_GetVerifyAll(_pHandle.value, pVerifyAll);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vVerifyAll = pVerifyAll.value;
      return vVerifyAll;
    } finally {
      calloc.free(pVerifyAll);
    }
  }

}

class BiometricVerificationRulesIterator implements Iterator<BiometricVerificationRule> {
  BiometricVerificationRulesIterator(this._list) : _count = _list.getCount();
  final BiometricVerificationRules _list;
  final int _count;
  int _index = -1;

  @override
  BiometricVerificationRule get current => _list.get(_index);

  @override
  bool moveNext() {
    _index++;
    return _index < _count;
  }
}
