import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'bioseal_native.dart';

class BiosealException implements Exception {
  final int _errorCode;
	
  BiosealException(this._errorCode);

  int get errorCode => _errorCode;

  String get message {
    final Pointer<Utf8> messagePtr = biosealSDK.id3Bioseal_GetBiosealErrorMessage(_errorCode) as Pointer<Utf8>;
    if (messagePtr.address == 0) {
      return "Undefined error";
    }
    return messagePtr.toDartString();
  }
}
