//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:convert';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'bioseal_sdk_generated_bindings.dart';
import 'bioseal_native.dart';

import '../id3_bioseal.dart';

/// Provides essential methods for initializing the SDK and accessing version information.
class BiosealLibrary {

  // Public methods
  /// Retrieves the library version as a 'X.Y.Z' formatted string.
  ///
  /// return A string that identifies the library version.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  static String getVersion() {
    Pointer<Char> pLibraryVersion = calloc.allocate(8);
    Pointer<Int> pLibraryVersionSize = calloc.allocate(1);
    pLibraryVersionSize[0] = 8;
    try {
      var err = biosealSDK.id3BiosealLibrary_GetVersion(pLibraryVersion, pLibraryVersionSize);
      if (err == BiosealError.insufficientBuffer.value) {
        calloc.free(pLibraryVersion);
        pLibraryVersion = calloc.allocate(pLibraryVersionSize.value);
        err = biosealSDK.id3BiosealLibrary_GetVersion(pLibraryVersion, pLibraryVersionSize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vLibraryVersion = utf8.decode(Uint8List.fromList(pLibraryVersion.cast<Uint8>().asTypedList(pLibraryVersionSize.value)));
      return vLibraryVersion;
    } finally {
      calloc.free(pLibraryVersion);
      calloc.free(pLibraryVersionSize);
    }
  }

  /// Retrieves the library version as a structure.
  ///
  /// return The version.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  static LibVersion getVersionEx() {
    Pointer<id3BiosealLibVersion> pVersion = calloc();
    var err = biosealSDK.id3BiosealLibrary_GetVersionEx(pVersion);
    if (err != BiosealError.success.value) {
    	calloc.free(pVersion);
    	throw BiosealException(err);
    }
    return LibVersion(pVersion);
  }

}

