//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:collection';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'bioseal_sdk_generated_bindings.dart';
import 'bioseal_native.dart';

import '../id3_bioseal.dart';

final _finalizer = NativeFinalizer(biosealSDK.addresses.id3BiosealCertificateExtensionList_Dispose.cast());

/// Represents a list of certificate extensions.
class CertificateExtensionList extends Object with IterableMixin<CertificateExtension> implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3BiosealCertificateExtensionList>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3BiosealCertificateExtensionList> get handle => _pHandle.value;

  /// Creates a new instance of the CertificateExtensionList class.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  CertificateExtensionList() {
    _pHandle = calloc();
    try {
      var err = biosealSDK.id3BiosealCertificateExtensionList_Initialize(_pHandle);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the CertificateExtensionList class.
  ///
  /// param handle     Handle to the CertificateExtensionList.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  CertificateExtensionList.fromHandle(Pointer<id3BiosealCertificateExtensionList> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this CertificateExtensionList.
  void dispose() {
    if (_disposable) {
      biosealSDK.id3BiosealCertificateExtensionList_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  /// Gets or sets the element at the specified index.
  operator [](int key) => get(key);

  /// Gets the number of elements contained in the list or dictionary.
  int get count => getCount();

  @override
  Iterator<CertificateExtension> get iterator => CertificateExtensionListIterator(this);

  // Public methods
  /// Gets an item of the CertificateExtensionList object.
  ///
  /// param index Index of the CertificateExtension item to get.
  /// return CertificateExtension item to get.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  CertificateExtension get(int index) {
    CertificateExtension certificateExtensionItem = CertificateExtension();
    var err = biosealSDK.id3BiosealCertificateExtensionList_Get(_pHandle.value, index, certificateExtensionItem.handle);
    if (err != BiosealError.success.value) {
      certificateExtensionItem.dispose();
      throw BiosealException(err);
    }
    return certificateExtensionItem;
  }

  /// Gets the number of elements in the CertificateExtensionList object.
  ///
  /// return Number of elements in the CertificateExtension object.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = biosealSDK.id3BiosealCertificateExtensionList_GetCount(_pHandle.value, pCount);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

}

class CertificateExtensionListIterator implements Iterator<CertificateExtension> {
  CertificateExtensionListIterator(this._list) : _count = _list.getCount();
  final CertificateExtensionList _list;
  final int _count;
  int _index = -1;

  @override
  CertificateExtension get current => _list.get(_index);

  @override
  bool moveNext() {
    _index++;
    return _index < _count;
  }
}
