//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:convert';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'bioseal_sdk_generated_bindings.dart';
import 'bioseal_native.dart';

import '../id3_bioseal.dart';

final _finalizer = NativeFinalizer(biosealSDK.addresses.id3BiosealCertificateInformation_Dispose.cast());

/// Represents the information about a certificate.
class CertificateInformation implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3BiosealCertificateInformation>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3BiosealCertificateInformation> get handle => _pHandle.value;

  /// Creates a new instance of the CertificateInformation class.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  CertificateInformation() {
    _pHandle = calloc();
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_Initialize(_pHandle);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the CertificateInformation class.
  ///
  /// param handle     Handle to the CertificateInformation.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  CertificateInformation.fromHandle(Pointer<id3BiosealCertificateInformation> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this CertificateInformation.
  void dispose() {
    if (_disposable) {
      biosealSDK.id3BiosealCertificateInformation_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }


  ///
  /// The common name (CN) of the certificate issuer.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String get issuerCommonName => getIssuerCommonName();

  ///
  /// The organization (O) of the certificate issuer.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String get issuerOrganization => getIssuerOrganization();

  ///
  /// The country (C) of the certificate issuer.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String get issuerCountry => getIssuerCountry();

  ///
  /// The organizational unit (OU) of the certificate issuer.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String get issuerOrganizationalUnit => getIssuerOrganizationalUnit();

  ///
  /// The distinguished name (DN) of the certificate issuer.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String get issuerDistinguishedName => getIssuerDistinguishedName();

  ///
  /// The subject common name (CN) from the certificate.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String get subjectCommonName => getSubjectCommonName();

  ///
  /// The organization (O) of the certificate subject.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String get subjectOrganization => getSubjectOrganization();

  ///
  /// The country (C) of the certificate subject.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String get subjectCountry => getSubjectCountry();

  ///
  /// The organizational unit (OU) of the certificate subject.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String get subjectOrganizationalUnit => getSubjectOrganizationalUnit();

  ///
  /// The subject distinguished (DN) name of the certificate.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String get subjectDistinguishedName => getSubjectDistinguishedName();

  ///
  /// The date in local time when a certificate becomes valid.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  DateTime get notBefore => getNotBefore();

  ///
  /// The date in local time after which a certificate is no longer valid.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  DateTime get notAfter => getNotAfter();

  ///
  /// The serial number of the certificate.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  Uint8List get serialNumber => getSerialNumber();

  ///
  /// The serial number from the certificate as a string.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String get serialNumberString => getSerialNumberString();

  ///
  /// The certificate data.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  Uint8List get data => getData();

  ///
  /// The OID of the certificate's signing algorithm.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String get signatureAlgorithm => getSignatureAlgorithm();

  ///
  /// The certificate version.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int get version => getVersion();

  ///
  /// The certificate public key.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  Uint8List get publicKey => getPublicKey();

  ///
  /// The certificate key usage list.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  StringArray get keyUsage => getKeyUsage();

  ///
  /// The certificate policies.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  StringArray get policies => getPolicies();

  ///
  /// The certificate extension list.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  CertificateExtensionList get certificateExtensionList => getCertificateExtensionList();

  // Public methods
  /// Gets the the common name (CN) of the certificate issuer.
  ///
  /// return The common name (CN) of the certificate issuer.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String getIssuerCommonName() {
    Pointer<Char> pIssuerCommonName = nullptr;
    Pointer<Int> pIssuerCommonNameSize = calloc.allocate(1);
    pIssuerCommonNameSize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetIssuerCommonName(_pHandle.value, pIssuerCommonName, pIssuerCommonNameSize);
      if (err == BiosealError.insufficientBuffer.value) {
        pIssuerCommonName = calloc.allocate(pIssuerCommonNameSize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetIssuerCommonName(_pHandle.value, pIssuerCommonName, pIssuerCommonNameSize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vIssuerCommonName = utf8.decode(Uint8List.fromList(pIssuerCommonName.cast<Uint8>().asTypedList(pIssuerCommonNameSize.value)));
      return vIssuerCommonName;
    } finally {
      calloc.free(pIssuerCommonName);
      calloc.free(pIssuerCommonNameSize);
    }
  }

  /// Gets the the organization (O) of the certificate issuer.
  ///
  /// return The organization (O) of the certificate issuer.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String getIssuerOrganization() {
    Pointer<Char> pIssuerOrganization = nullptr;
    Pointer<Int> pIssuerOrganizationSize = calloc.allocate(1);
    pIssuerOrganizationSize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetIssuerOrganization(_pHandle.value, pIssuerOrganization, pIssuerOrganizationSize);
      if (err == BiosealError.insufficientBuffer.value) {
        pIssuerOrganization = calloc.allocate(pIssuerOrganizationSize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetIssuerOrganization(_pHandle.value, pIssuerOrganization, pIssuerOrganizationSize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vIssuerOrganization = utf8.decode(Uint8List.fromList(pIssuerOrganization.cast<Uint8>().asTypedList(pIssuerOrganizationSize.value)));
      return vIssuerOrganization;
    } finally {
      calloc.free(pIssuerOrganization);
      calloc.free(pIssuerOrganizationSize);
    }
  }

  /// Gets the the country (C) of the certificate issuer.
  ///
  /// return The country (C) of the certificate issuer.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String getIssuerCountry() {
    Pointer<Char> pIssuerCountry = nullptr;
    Pointer<Int> pIssuerCountrySize = calloc.allocate(1);
    pIssuerCountrySize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetIssuerCountry(_pHandle.value, pIssuerCountry, pIssuerCountrySize);
      if (err == BiosealError.insufficientBuffer.value) {
        pIssuerCountry = calloc.allocate(pIssuerCountrySize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetIssuerCountry(_pHandle.value, pIssuerCountry, pIssuerCountrySize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vIssuerCountry = utf8.decode(Uint8List.fromList(pIssuerCountry.cast<Uint8>().asTypedList(pIssuerCountrySize.value)));
      return vIssuerCountry;
    } finally {
      calloc.free(pIssuerCountry);
      calloc.free(pIssuerCountrySize);
    }
  }

  /// Gets the the organizational unit (OU) of the certificate issuer.
  ///
  /// return The organizational unit (OU) of the certificate issuer.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String getIssuerOrganizationalUnit() {
    Pointer<Char> pIssuerOrganizationalUnit = nullptr;
    Pointer<Int> pIssuerOrganizationalUnitSize = calloc.allocate(1);
    pIssuerOrganizationalUnitSize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetIssuerOrganizationalUnit(_pHandle.value, pIssuerOrganizationalUnit, pIssuerOrganizationalUnitSize);
      if (err == BiosealError.insufficientBuffer.value) {
        pIssuerOrganizationalUnit = calloc.allocate(pIssuerOrganizationalUnitSize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetIssuerOrganizationalUnit(_pHandle.value, pIssuerOrganizationalUnit, pIssuerOrganizationalUnitSize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vIssuerOrganizationalUnit = utf8.decode(Uint8List.fromList(pIssuerOrganizationalUnit.cast<Uint8>().asTypedList(pIssuerOrganizationalUnitSize.value)));
      return vIssuerOrganizationalUnit;
    } finally {
      calloc.free(pIssuerOrganizationalUnit);
      calloc.free(pIssuerOrganizationalUnitSize);
    }
  }

  /// Gets the the distinguished name (DN) of the certificate issuer.
  ///
  /// return The distinguished name (DN) of the certificate issuer.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String getIssuerDistinguishedName() {
    Pointer<Char> pIssuerDistinguishedName = nullptr;
    Pointer<Int> pIssuerDistinguishedNameSize = calloc.allocate(1);
    pIssuerDistinguishedNameSize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetIssuerDistinguishedName(_pHandle.value, pIssuerDistinguishedName, pIssuerDistinguishedNameSize);
      if (err == BiosealError.insufficientBuffer.value) {
        pIssuerDistinguishedName = calloc.allocate(pIssuerDistinguishedNameSize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetIssuerDistinguishedName(_pHandle.value, pIssuerDistinguishedName, pIssuerDistinguishedNameSize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vIssuerDistinguishedName = utf8.decode(Uint8List.fromList(pIssuerDistinguishedName.cast<Uint8>().asTypedList(pIssuerDistinguishedNameSize.value)));
      return vIssuerDistinguishedName;
    } finally {
      calloc.free(pIssuerDistinguishedName);
      calloc.free(pIssuerDistinguishedNameSize);
    }
  }

  /// Gets the the subject common name (CN) from the certificate.
  ///
  /// return The subject common name (CN) from the certificate.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String getSubjectCommonName() {
    Pointer<Char> pSubjectCommonName = nullptr;
    Pointer<Int> pSubjectCommonNameSize = calloc.allocate(1);
    pSubjectCommonNameSize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetSubjectCommonName(_pHandle.value, pSubjectCommonName, pSubjectCommonNameSize);
      if (err == BiosealError.insufficientBuffer.value) {
        pSubjectCommonName = calloc.allocate(pSubjectCommonNameSize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetSubjectCommonName(_pHandle.value, pSubjectCommonName, pSubjectCommonNameSize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vSubjectCommonName = utf8.decode(Uint8List.fromList(pSubjectCommonName.cast<Uint8>().asTypedList(pSubjectCommonNameSize.value)));
      return vSubjectCommonName;
    } finally {
      calloc.free(pSubjectCommonName);
      calloc.free(pSubjectCommonNameSize);
    }
  }

  /// Gets the the organization (O) of the certificate subject.
  ///
  /// return The organization (O) of the certificate subject.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String getSubjectOrganization() {
    Pointer<Char> pSubjectOrganization = nullptr;
    Pointer<Int> pSubjectOrganizationSize = calloc.allocate(1);
    pSubjectOrganizationSize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetSubjectOrganization(_pHandle.value, pSubjectOrganization, pSubjectOrganizationSize);
      if (err == BiosealError.insufficientBuffer.value) {
        pSubjectOrganization = calloc.allocate(pSubjectOrganizationSize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetSubjectOrganization(_pHandle.value, pSubjectOrganization, pSubjectOrganizationSize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vSubjectOrganization = utf8.decode(Uint8List.fromList(pSubjectOrganization.cast<Uint8>().asTypedList(pSubjectOrganizationSize.value)));
      return vSubjectOrganization;
    } finally {
      calloc.free(pSubjectOrganization);
      calloc.free(pSubjectOrganizationSize);
    }
  }

  /// Gets the the country (C) of the certificate subject.
  ///
  /// return The country (C) of the certificate subject.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String getSubjectCountry() {
    Pointer<Char> pSubjectCountry = nullptr;
    Pointer<Int> pSubjectCountrySize = calloc.allocate(1);
    pSubjectCountrySize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetSubjectCountry(_pHandle.value, pSubjectCountry, pSubjectCountrySize);
      if (err == BiosealError.insufficientBuffer.value) {
        pSubjectCountry = calloc.allocate(pSubjectCountrySize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetSubjectCountry(_pHandle.value, pSubjectCountry, pSubjectCountrySize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vSubjectCountry = utf8.decode(Uint8List.fromList(pSubjectCountry.cast<Uint8>().asTypedList(pSubjectCountrySize.value)));
      return vSubjectCountry;
    } finally {
      calloc.free(pSubjectCountry);
      calloc.free(pSubjectCountrySize);
    }
  }

  /// Gets the the organizational unit (OU) of the certificate subject.
  ///
  /// return The organizational unit (OU) of the certificate subject.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String getSubjectOrganizationalUnit() {
    Pointer<Char> pSubjectOrganizationalUnit = nullptr;
    Pointer<Int> pSubjectOrganizationalUnitSize = calloc.allocate(1);
    pSubjectOrganizationalUnitSize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetSubjectOrganizationalUnit(_pHandle.value, pSubjectOrganizationalUnit, pSubjectOrganizationalUnitSize);
      if (err == BiosealError.insufficientBuffer.value) {
        pSubjectOrganizationalUnit = calloc.allocate(pSubjectOrganizationalUnitSize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetSubjectOrganizationalUnit(_pHandle.value, pSubjectOrganizationalUnit, pSubjectOrganizationalUnitSize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vSubjectOrganizationalUnit = utf8.decode(Uint8List.fromList(pSubjectOrganizationalUnit.cast<Uint8>().asTypedList(pSubjectOrganizationalUnitSize.value)));
      return vSubjectOrganizationalUnit;
    } finally {
      calloc.free(pSubjectOrganizationalUnit);
      calloc.free(pSubjectOrganizationalUnitSize);
    }
  }

  /// Gets the the subject distinguished (DN) name of the certificate.
  ///
  /// return The subject distinguished (DN) name of the certificate.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String getSubjectDistinguishedName() {
    Pointer<Char> pSubjectDistinguishedName = nullptr;
    Pointer<Int> pSubjectDistinguishedNameSize = calloc.allocate(1);
    pSubjectDistinguishedNameSize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetSubjectDistinguishedName(_pHandle.value, pSubjectDistinguishedName, pSubjectDistinguishedNameSize);
      if (err == BiosealError.insufficientBuffer.value) {
        pSubjectDistinguishedName = calloc.allocate(pSubjectDistinguishedNameSize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetSubjectDistinguishedName(_pHandle.value, pSubjectDistinguishedName, pSubjectDistinguishedNameSize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vSubjectDistinguishedName = utf8.decode(Uint8List.fromList(pSubjectDistinguishedName.cast<Uint8>().asTypedList(pSubjectDistinguishedNameSize.value)));
      return vSubjectDistinguishedName;
    } finally {
      calloc.free(pSubjectDistinguishedName);
      calloc.free(pSubjectDistinguishedNameSize);
    }
  }

  /// Gets the the date in local time when a certificate becomes valid.
  ///
  /// return The date in local time when a certificate becomes valid.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  DateTime getNotBefore() {
    DateTime notBefore = DateTime();
    var err = biosealSDK.id3BiosealCertificateInformation_GetNotBefore(_pHandle.value, notBefore.handle);
    if (err != BiosealError.success.value) {
      notBefore.dispose();
      throw BiosealException(err);
    }
    return notBefore;
  }

  /// Gets the the date in local time after which a certificate is no longer valid.
  ///
  /// return The date in local time after which a certificate is no longer valid.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  DateTime getNotAfter() {
    DateTime notAfter = DateTime();
    var err = biosealSDK.id3BiosealCertificateInformation_GetNotAfter(_pHandle.value, notAfter.handle);
    if (err != BiosealError.success.value) {
      notAfter.dispose();
      throw BiosealException(err);
    }
    return notAfter;
  }

  /// Gets the the serial number of the certificate.
  ///
  /// return The serial number of the certificate.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  Uint8List getSerialNumber() {
    Pointer<UnsignedChar> pSerialNumber = nullptr;
    Pointer<Int> pSerialNumberSize = calloc();
    pSerialNumberSize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetSerialNumber(_pHandle.value, pSerialNumber, pSerialNumberSize);
      if (err == BiosealError.insufficientBuffer.value) {
        pSerialNumber = calloc.allocate(pSerialNumberSize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetSerialNumber(_pHandle.value, pSerialNumber, pSerialNumberSize);
      }
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vSerialNumber = Uint8List.fromList(pSerialNumber.cast<Uint8>().asTypedList(pSerialNumberSize.value));
      return vSerialNumber;
    } finally {
      calloc.free(pSerialNumber);
      calloc.free(pSerialNumberSize);
    }
  }

  /// Gets the the serial number from the certificate as a string.
  ///
  /// return The serial number from the certificate as a string.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String getSerialNumberString() {
    Pointer<Char> pSerialNumberString = nullptr;
    Pointer<Int> pSerialNumberStringSize = calloc.allocate(1);
    pSerialNumberStringSize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetSerialNumberString(_pHandle.value, pSerialNumberString, pSerialNumberStringSize);
      if (err == BiosealError.insufficientBuffer.value) {
        pSerialNumberString = calloc.allocate(pSerialNumberStringSize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetSerialNumberString(_pHandle.value, pSerialNumberString, pSerialNumberStringSize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vSerialNumberString = utf8.decode(Uint8List.fromList(pSerialNumberString.cast<Uint8>().asTypedList(pSerialNumberStringSize.value)));
      return vSerialNumberString;
    } finally {
      calloc.free(pSerialNumberString);
      calloc.free(pSerialNumberStringSize);
    }
  }

  /// Gets the the certificate data.
  ///
  /// return The certificate data.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  Uint8List getData() {
    Pointer<UnsignedChar> pData = nullptr;
    Pointer<Int> pDataSize = calloc();
    pDataSize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetData(_pHandle.value, pData, pDataSize);
      if (err == BiosealError.insufficientBuffer.value) {
        pData = calloc.allocate(pDataSize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetData(_pHandle.value, pData, pDataSize);
      }
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vData = Uint8List.fromList(pData.cast<Uint8>().asTypedList(pDataSize.value));
      return vData;
    } finally {
      calloc.free(pData);
      calloc.free(pDataSize);
    }
  }

  /// Gets the the OID of the certificate's signing algorithm.
  ///
  /// return The OID of the certificate's signing algorithm.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String getSignatureAlgorithm() {
    Pointer<Char> pSignatureAlgorithm = nullptr;
    Pointer<Int> pSignatureAlgorithmSize = calloc.allocate(1);
    pSignatureAlgorithmSize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetSignatureAlgorithm(_pHandle.value, pSignatureAlgorithm, pSignatureAlgorithmSize);
      if (err == BiosealError.insufficientBuffer.value) {
        pSignatureAlgorithm = calloc.allocate(pSignatureAlgorithmSize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetSignatureAlgorithm(_pHandle.value, pSignatureAlgorithm, pSignatureAlgorithmSize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vSignatureAlgorithm = utf8.decode(Uint8List.fromList(pSignatureAlgorithm.cast<Uint8>().asTypedList(pSignatureAlgorithmSize.value)));
      return vSignatureAlgorithm;
    } finally {
      calloc.free(pSignatureAlgorithm);
      calloc.free(pSignatureAlgorithmSize);
    }
  }

  /// Gets the the certificate version.
  ///
  /// return The certificate version.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int getVersion() {
    Pointer<Int> pVersion = calloc();
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetVersion(_pHandle.value, pVersion);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vVersion = pVersion.value;
      return vVersion;
    } finally {
      calloc.free(pVersion);
    }
  }

  /// Gets the the certificate public key.
  ///
  /// return The certificate public key.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  Uint8List getPublicKey() {
    Pointer<UnsignedChar> pPublicKey = nullptr;
    Pointer<Int> pPublicKeySize = calloc();
    pPublicKeySize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealCertificateInformation_GetPublicKey(_pHandle.value, pPublicKey, pPublicKeySize);
      if (err == BiosealError.insufficientBuffer.value) {
        pPublicKey = calloc.allocate(pPublicKeySize.value);
        err = biosealSDK.id3BiosealCertificateInformation_GetPublicKey(_pHandle.value, pPublicKey, pPublicKeySize);
      }
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vPublicKey = Uint8List.fromList(pPublicKey.cast<Uint8>().asTypedList(pPublicKeySize.value));
      return vPublicKey;
    } finally {
      calloc.free(pPublicKey);
      calloc.free(pPublicKeySize);
    }
  }

  /// Gets the the certificate key usage list.
  ///
  /// return The certificate key usage list.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  StringArray getKeyUsage() {
    StringArray keyUsage = StringArray();
    var err = biosealSDK.id3BiosealCertificateInformation_GetKeyUsage(_pHandle.value, keyUsage.handle);
    if (err != BiosealError.success.value) {
      keyUsage.dispose();
      throw BiosealException(err);
    }
    return keyUsage;
  }

  /// Gets the the certificate policies.
  ///
  /// return The certificate policies.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  StringArray getPolicies() {
    StringArray policies = StringArray();
    var err = biosealSDK.id3BiosealCertificateInformation_GetPolicies(_pHandle.value, policies.handle);
    if (err != BiosealError.success.value) {
      policies.dispose();
      throw BiosealException(err);
    }
    return policies;
  }

  /// Gets the the certificate extension list.
  ///
  /// return The certificate extension list.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  CertificateExtensionList getCertificateExtensionList() {
    CertificateExtensionList certificateExtensionList = CertificateExtensionList();
    var err = biosealSDK.id3BiosealCertificateInformation_GetCertificateExtensionList(_pHandle.value, certificateExtensionList.handle);
    if (err != BiosealError.success.value) {
      certificateExtensionList.dispose();
      throw BiosealException(err);
    }
    return certificateExtensionList;
  }

}

